/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import org.testng.annotations.Test;

public class TestDecimalParametricType
extends AbstractTestFunctions {
    @Test
    public void decimalIsCreatedWithPrecisionAndScaleDefined() {
        this.assertDecimalFunction("CAST(1 AS DECIMAL(2, 0))", TestDecimalParametricType.decimal("01"));
        this.assertDecimalFunction("CAST(0.01 AS DECIMAL(2, 2))", TestDecimalParametricType.decimal(".01"));
        this.assertDecimalFunction("CAST(0.02 AS DECIMAL(10, 10))", TestDecimalParametricType.decimal(".0200000000"));
        this.assertDecimalFunction("CAST(0.02 AS DECIMAL(10, 8))", TestDecimalParametricType.decimal("00.02000000"));
    }

    @Test
    public void decimalIsCreatedWithOnlyPrecisionDefined() {
        this.assertDecimalFunction("CAST(1 AS DECIMAL(2))", TestDecimalParametricType.decimal("01"));
        this.assertDecimalFunction("CAST(-22 AS DECIMAL(3))", TestDecimalParametricType.decimal("-022"));
        this.assertDecimalFunction("CAST(31.41 AS DECIMAL(4))", TestDecimalParametricType.decimal("0031"));
    }

    @Test
    public void decimalIsCreatedWithoutParameters() {
        this.assertDecimalFunction("CAST(1 AS DECIMAL)", TestDecimalParametricType.maxPrecisionDecimal(1L));
        this.assertDecimalFunction("CAST(-22 AS DECIMAL)", TestDecimalParametricType.maxPrecisionDecimal(-22L));
        this.assertDecimalFunction("CAST(31.41 AS DECIMAL)", TestDecimalParametricType.maxPrecisionDecimal(31L));
    }

    @Test
    public void creatingDecimalRoundsValueProperly() {
        this.assertDecimalFunction("CAST(0.022 AS DECIMAL(4, 2))", TestDecimalParametricType.decimal("00.02"));
        this.assertDecimalFunction("CAST(0.025 AS DECIMAL(4, 2))", TestDecimalParametricType.decimal("00.03"));
        this.assertDecimalFunction("CAST(32.01 AS DECIMAL(3, 1))", TestDecimalParametricType.decimal("32.0"));
        this.assertDecimalFunction("CAST(32.06 AS DECIMAL(3, 1))", TestDecimalParametricType.decimal("32.1"));
        this.assertDecimalFunction("CAST(32.1 AS DECIMAL(3, 0))", TestDecimalParametricType.decimal("032"));
        this.assertDecimalFunction("CAST(32.5 AS DECIMAL(3, 0))", TestDecimalParametricType.decimal("033"));
        this.assertDecimalFunction("CAST(-0.022 AS DECIMAL(4, 2))", TestDecimalParametricType.decimal("-00.02"));
        this.assertDecimalFunction("CAST(-0.025 AS DECIMAL(4, 2))", TestDecimalParametricType.decimal("-00.03"));
    }

    @Test
    public void decimalIsNotCreatedWhenScaleExceedsPrecision() {
        this.assertInvalidFunction("CAST(1 AS DECIMAL(1,2))", "DECIMAL scale must be in range [0, precision (1)]: 2");
        this.assertInvalidFunction("CAST(-22 AS DECIMAL(20,21))", "DECIMAL scale must be in range [0, precision (20)]: 21");
        this.assertInvalidFunction("CAST(31.41 AS DECIMAL(0,1))", "DECIMAL precision must be in range [1, 38]: 0");
    }

    @Test
    public void decimalWithZeroLengthCannotBeCreated() {
        this.assertInvalidFunction("CAST(1 AS DECIMAL(0,0))", "DECIMAL precision must be in range [1, 38]: 0");
        this.assertInvalidFunction("CAST(0 AS DECIMAL(0,0))", "DECIMAL precision must be in range [1, 38]: 0");
        this.assertInvalidFunction("CAST(1 AS DECIMAL(0))", "DECIMAL precision must be in range [1, 38]: 0");
        this.assertInvalidFunction("CAST(0 AS DECIMAL(0))", "DECIMAL precision must be in range [1, 38]: 0");
    }
}

