/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.IntervalYearMonthType;
import io.prestosql.type.SqlIntervalYearMonth;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestIntervalYearMonth
extends AbstractTestFunctions {
    private static final int MAX_SHORT = Short.MAX_VALUE;

    @Test
    public void testObject() {
        Assert.assertEquals((Object)new SqlIntervalYearMonth(3, 11), (Object)new SqlIntervalYearMonth(47));
        Assert.assertEquals((Object)new SqlIntervalYearMonth(-3, -11), (Object)new SqlIntervalYearMonth(-47));
        Assert.assertEquals((Object)new SqlIntervalYearMonth(Short.MAX_VALUE, 0), (Object)new SqlIntervalYearMonth(393204));
        Assert.assertEquals((Object)new SqlIntervalYearMonth(Short.MAX_VALUE, Short.MAX_VALUE), (Object)new SqlIntervalYearMonth(425971));
        Assert.assertEquals((Object)new SqlIntervalYearMonth(-32767, 0), (Object)new SqlIntervalYearMonth(-393204));
        Assert.assertEquals((Object)new SqlIntervalYearMonth(-32767, -32767), (Object)new SqlIntervalYearMonth(-425971));
    }

    @Test
    public void testLiteral() {
        this.assertLiteral("INTERVAL '124-30' YEAR TO MONTH", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(124, 30));
        this.assertLiteral("INTERVAL '124' YEAR TO MONTH", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(124, 0));
        this.assertLiteral("INTERVAL '124' YEAR", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(124, 0));
        this.assertLiteral("INTERVAL '30' MONTH", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(0, 30));
        this.assertLiteral(String.format("INTERVAL '%s' YEAR", Short.MAX_VALUE), (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(Short.MAX_VALUE, 0));
        this.assertLiteral(String.format("INTERVAL '%s' MONTH", Short.MAX_VALUE), (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(0, Short.MAX_VALUE));
        this.assertLiteral(String.format("INTERVAL '%s-%s' YEAR TO MONTH", Short.MAX_VALUE, Short.MAX_VALUE), (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    private void assertLiteral(String projection, Type expectedType, SqlIntervalYearMonth expectedValue) {
        this.assertFunction(projection, expectedType, expectedValue);
        projection = projection.replace("INTERVAL '", "INTERVAL '-");
        expectedValue = new SqlIntervalYearMonth(-expectedValue.getMonths());
        this.assertFunction(projection, expectedType, expectedValue);
    }

    @Test
    public void testInvalidLiteral() {
        this.assertInvalidFunction("INTERVAL '124X' YEAR", "Invalid INTERVAL YEAR value: 124X");
        this.assertInvalidFunction("INTERVAL '124-30' YEAR", "Invalid INTERVAL YEAR value: 124-30");
        this.assertInvalidFunction("INTERVAL '124-X' YEAR TO MONTH", "Invalid INTERVAL YEAR TO MONTH value: 124-X");
        this.assertInvalidFunction("INTERVAL '124--30' YEAR TO MONTH", "Invalid INTERVAL YEAR TO MONTH value: 124--30");
        this.assertInvalidFunction("INTERVAL '--124--30' YEAR TO MONTH", "Invalid INTERVAL YEAR TO MONTH value: --124--30");
    }

    @Test
    public void testAdd() {
        this.assertFunction("INTERVAL '3' MONTH + INTERVAL '3' MONTH", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(6));
        this.assertFunction("INTERVAL '6' YEAR + INTERVAL '6' YEAR", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(144));
        this.assertFunction("INTERVAL '3' MONTH + INTERVAL '6' YEAR", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(75));
    }

    @Test
    public void testSubtract() {
        this.assertFunction("INTERVAL '6' MONTH - INTERVAL '3' MONTH", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(3));
        this.assertFunction("INTERVAL '9' YEAR - INTERVAL '6' YEAR", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(36));
        this.assertFunction("INTERVAL '3' MONTH - INTERVAL '6' YEAR", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(-69));
    }

    @Test
    public void testMultiply() {
        this.assertFunction("INTERVAL '6' MONTH * 2", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(12));
        this.assertFunction("2 * INTERVAL '6' MONTH", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(12));
        this.assertFunction("INTERVAL '10' MONTH * 2.5", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(25));
        this.assertFunction("2.5 * INTERVAL '10' MONTH", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(25));
        this.assertFunction("INTERVAL '6' YEAR * 2", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(144));
        this.assertFunction("2 * INTERVAL '6' YEAR", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(144));
        this.assertFunction("INTERVAL '1' YEAR * 2.5", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(30));
        this.assertFunction("2.5 * INTERVAL '1' YEAR", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(30));
        this.assertInvalidFunction("INTERVAL '6' MONTH * nan()", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("nan() * INTERVAL '6' YEAR", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testDivide() {
        this.assertFunction("INTERVAL '30' MONTH / 2", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(15));
        this.assertFunction("INTERVAL '60' MONTH / 2.5", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(24));
        this.assertFunction("INTERVAL '3' YEAR / 2", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(18));
        this.assertFunction("INTERVAL '4' YEAR / 4.8", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(10));
        this.assertInvalidFunction("INTERVAL '6' MONTH / nan()", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("INTERVAL '6' YEAR / nan()", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("INTERVAL '6' MONTH / 0E0", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("INTERVAL '6' YEAR / 0", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testNegation() {
        this.assertFunction("- INTERVAL '3' MONTH", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(-3));
        this.assertFunction("- INTERVAL '6' YEAR", (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, new SqlIntervalYearMonth(-72));
    }

    @Test
    public void testEqual() {
        this.assertFunction("INTERVAL '3' MONTH = INTERVAL '3' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' YEAR = INTERVAL '6' YEAR", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH = INTERVAL '4' MONTH", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '7' YEAR = INTERVAL '6' YEAR", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("INTERVAL '3' MONTH <> INTERVAL '4' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' YEAR <> INTERVAL '7' YEAR", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH <> INTERVAL '3' MONTH", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' YEAR <> INTERVAL '6' YEAR", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("INTERVAL '3' MONTH < INTERVAL '4' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' YEAR < INTERVAL '7' YEAR", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH < INTERVAL '3' MONTH", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '3' MONTH < INTERVAL '2' MONTH", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' YEAR < INTERVAL '6' YEAR", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' YEAR < INTERVAL '5' YEAR", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("INTERVAL '3' MONTH <= INTERVAL '4' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH <= INTERVAL '3' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' YEAR <= INTERVAL '6' YEAR", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' YEAR <= INTERVAL '7' YEAR", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH <= INTERVAL '2' MONTH", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' YEAR <= INTERVAL '5' YEAR", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("INTERVAL '3' MONTH > INTERVAL '2' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' YEAR > INTERVAL '5' YEAR", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH > INTERVAL '3' MONTH", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '3' MONTH > INTERVAL '4' MONTH", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' YEAR > INTERVAL '6' YEAR", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' YEAR > INTERVAL '7' YEAR", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("INTERVAL '3' MONTH >= INTERVAL '2' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH >= INTERVAL '3' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' YEAR >= INTERVAL '5' YEAR", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' YEAR >= INTERVAL '6' YEAR", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH >= INTERVAL '4' MONTH", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' YEAR >= INTERVAL '7' YEAR", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '2' MONTH and INTERVAL '4' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '3' MONTH and INTERVAL '4' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '2' MONTH and INTERVAL '3' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '3' MONTH and INTERVAL '3' MONTH", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '4' MONTH and INTERVAL '5' MONTH", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '1' MONTH and INTERVAL '2' MONTH", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '4' MONTH and INTERVAL '2' MONTH", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastToSlice() {
        this.assertFunction("cast(INTERVAL '124-30' YEAR TO MONTH as varchar)", (Type)VarcharType.VARCHAR, "126-6");
        this.assertFunction("cast(INTERVAL '124-30' YEAR TO MONTH as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalYearMonth(124, 30).toString());
        this.assertFunction("cast(INTERVAL '124' YEAR TO MONTH as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalYearMonth(124, 0).toString());
        this.assertFunction("cast(INTERVAL '124' YEAR as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalYearMonth(124, 0).toString());
        this.assertFunction("cast(INTERVAL '30' MONTH as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalYearMonth(0, 30).toString());
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as INTERVAL YEAR TO MONTH)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "INTERVAL '124' YEAR TO MONTH", (Type)BooleanType.BOOLEAN, false);
    }
}

