/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.DateTimeTestingUtils;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.assertions.PrestoExceptionAssert;
import io.prestosql.type.JsonType;
import io.prestosql.util.StructuralTestUtil;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJsonOperators
extends AbstractTestFunctions {
    private LocalQueryRunner runner;

    @BeforeClass
    public void setUp() {
        this.runner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        if (this.runner != null) {
            this.runner.close();
            this.runner = null;
        }
    }

    @Test
    public void testCastToBigint() {
        this.assertFunction("cast(JSON 'null' as BIGINT)", (Type)BigintType.BIGINT, null);
        this.assertFunction("cast(JSON '128' as BIGINT)", (Type)BigintType.BIGINT, 128L);
        this.assertInvalidFunction("cast(JSON '12345678901234567890' as BIGINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON '128.9' as BIGINT)", (Type)BigintType.BIGINT, 129L);
        this.assertFunction("cast(JSON '1234567890123456789.0' as BIGINT)", (Type)BigintType.BIGINT, 1234567890123456768L);
        this.assertInvalidFunction("cast(JSON '12345678901234567890.0' as BIGINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON '1e-324' as BIGINT)", (Type)BigintType.BIGINT, 0L);
        this.assertInvalidFunction("cast(JSON '1e309' as BIGINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON 'true' as BIGINT)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("cast(JSON 'false' as BIGINT)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("cast(JSON '\"128\"' as BIGINT)", (Type)BigintType.BIGINT, 128L);
        this.assertInvalidFunction("cast(JSON '\"12345678901234567890\"' as BIGINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"128.9\"' as BIGINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"true\"' as BIGINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"false\"' as BIGINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON ' 128' as BIGINT)", (Type)BigintType.BIGINT, 128L);
        this.assertFunction("cast(json_extract('{\"x\":999}', '$.x') as BIGINT)", (Type)BigintType.BIGINT, 999L);
        this.assertInvalidCast("cast(JSON '{ \"x\" : 123}' as BIGINT)");
    }

    @Test
    public void testCastToInteger() {
        this.assertFunction("cast(JSON 'null' as INTEGER)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("cast(JSON '128' as INTEGER)", (Type)IntegerType.INTEGER, 128);
        this.assertInvalidFunction("cast(JSON '12345678901' as INTEGER)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON '128.9' as INTEGER)", (Type)IntegerType.INTEGER, 129);
        this.assertInvalidFunction("cast(JSON '12345678901.0' as INTEGER)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON '1e-324' as INTEGER)", (Type)IntegerType.INTEGER, 0);
        this.assertInvalidFunction("cast(JSON '1e309' as INTEGER)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON 'true' as INTEGER)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("cast(JSON 'false' as INTEGER)", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("cast(JSON '\"128\"' as INTEGER)", (Type)IntegerType.INTEGER, 128);
        this.assertInvalidFunction("cast(JSON '\"12345678901234567890\"' as INTEGER)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"128.9\"' as INTEGER)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"true\"' as INTEGER)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"false\"' as INTEGER)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON ' 128' as INTEGER)", (Type)IntegerType.INTEGER, 128);
        this.assertFunction("cast(json_extract('{\"x\":999}', '$.x') as INTEGER)", (Type)IntegerType.INTEGER, 999);
        this.assertInvalidCast("cast(JSON '{ \"x\" : 123}' as INTEGER)");
    }

    @Test
    public void testCastToSmallint() {
        this.assertFunction("cast(JSON 'null' as SMALLINT)", (Type)SmallintType.SMALLINT, null);
        this.assertFunction("cast(JSON '128' as SMALLINT)", (Type)SmallintType.SMALLINT, (short)128);
        this.assertInvalidFunction("cast(JSON '123456' as SMALLINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON '128.9' as SMALLINT)", (Type)SmallintType.SMALLINT, (short)129);
        this.assertInvalidFunction("cast(JSON '123456.0' as SMALLINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON '1e-324' as SMALLINT)", (Type)SmallintType.SMALLINT, (short)0);
        this.assertInvalidFunction("cast(JSON '1e309' as SMALLINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON 'true' as SMALLINT)", (Type)SmallintType.SMALLINT, (short)1);
        this.assertFunction("cast(JSON 'false' as SMALLINT)", (Type)SmallintType.SMALLINT, (short)0);
        this.assertFunction("cast(JSON '\"128\"' as SMALLINT)", (Type)SmallintType.SMALLINT, (short)128);
        this.assertInvalidFunction("cast(JSON '\"123456\"' as SMALLINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"128.9\"' as SMALLINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"true\"' as SMALLINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"false\"' as SMALLINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON ' 128' as SMALLINT)", (Type)SmallintType.SMALLINT, (short)128);
        this.assertFunction("cast(json_extract('{\"x\":999}', '$.x') as SMALLINT)", (Type)SmallintType.SMALLINT, (short)999);
        this.assertInvalidCast("cast(JSON '{ \"x\" : 123}' as SMALLINT)");
    }

    @Test
    public void testCastToTinyint() {
        this.assertFunction("cast(JSON 'null' as TINYINT)", (Type)TinyintType.TINYINT, null);
        this.assertFunction("cast(JSON '12' as TINYINT)", (Type)TinyintType.TINYINT, (byte)12);
        this.assertInvalidFunction("cast(JSON '1234' as TINYINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON '12.9' as TINYINT)", (Type)TinyintType.TINYINT, (byte)13);
        this.assertInvalidFunction("cast(JSON '1234.0' as TINYINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON '1e-324' as TINYINT)", (Type)TinyintType.TINYINT, (byte)0);
        this.assertInvalidFunction("cast(JSON '1e309' as TINYINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON 'true' as TINYINT)", (Type)TinyintType.TINYINT, (byte)1);
        this.assertFunction("cast(JSON 'false' as TINYINT)", (Type)TinyintType.TINYINT, (byte)0);
        this.assertFunction("cast(JSON '\"12\"' as TINYINT)", (Type)TinyintType.TINYINT, (byte)12);
        this.assertInvalidFunction("cast(JSON '\"1234\"' as TINYINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"12.9\"' as TINYINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"true\"' as TINYINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"false\"' as TINYINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON ' 12' as TINYINT)", (Type)TinyintType.TINYINT, (byte)12);
        this.assertFunction("cast(json_extract('{\"x\":99}', '$.x') as TINYINT)", (Type)TinyintType.TINYINT, (byte)99);
        this.assertInvalidCast("cast(JSON '{ \"x\" : 123}' as TINYINT)");
    }

    @Test
    public void testTypeConstructor() {
        this.assertFunction("JSON '123'", (Type)JsonType.JSON, "123");
        this.assertFunction("JSON '[4,5,6]'", (Type)JsonType.JSON, "[4,5,6]");
        this.assertFunction("JSON '{ \"a\": 789 }'", (Type)JsonType.JSON, "{\"a\":789}");
        this.assertFunction("JSON 'null'", (Type)JsonType.JSON, "null");
        this.assertFunction("JSON '[null]'", (Type)JsonType.JSON, "[null]");
        this.assertFunction("JSON '[13,null,42]'", (Type)JsonType.JSON, "[13,null,42]");
        this.assertFunction("JSON '{\"x\": null}'", (Type)JsonType.JSON, "{\"x\":null}");
    }

    @Test
    public void testCastFromIntegrals() {
        this.assertFunction("cast(cast (null as integer) as JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(cast (null as bigint) as JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(cast (null as smallint) as JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(cast (null as tinyint) as JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(128 as JSON)", (Type)JsonType.JSON, "128");
        this.assertFunction("cast(BIGINT '128' as JSON)", (Type)JsonType.JSON, "128");
        this.assertFunction("cast(SMALLINT '128' as JSON)", (Type)JsonType.JSON, "128");
        this.assertFunction("cast(TINYINT '127' as JSON)", (Type)JsonType.JSON, "127");
    }

    @Test
    public void testCastToDouble() {
        this.assertFunction("cast(JSON 'null' as DOUBLE)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("cast(JSON '128' as DOUBLE)", (Type)DoubleType.DOUBLE, 128.0);
        this.assertFunction("cast(JSON '12345678901234567890' as DOUBLE)", (Type)DoubleType.DOUBLE, 1.2345678901234567E19);
        this.assertFunction("cast(JSON '128.9' as DOUBLE)", (Type)DoubleType.DOUBLE, 128.9);
        this.assertFunction("cast(JSON '1e-324' as DOUBLE)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("cast(JSON '1e309' as DOUBLE)", (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY);
        this.assertFunction("cast(JSON '-1e309' as DOUBLE)", (Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY);
        this.assertFunction("cast(JSON 'true' as DOUBLE)", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("cast(JSON 'false' as DOUBLE)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("cast(JSON '\"128\"' as DOUBLE)", (Type)DoubleType.DOUBLE, 128.0);
        this.assertFunction("cast(JSON '\"12345678901234567890\"' as DOUBLE)", (Type)DoubleType.DOUBLE, 1.2345678901234567E19);
        this.assertFunction("cast(JSON '\"128.9\"' as DOUBLE)", (Type)DoubleType.DOUBLE, 128.9);
        this.assertFunction("cast(JSON '\"NaN\"' as DOUBLE)", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("cast(JSON '\"Infinity\"' as DOUBLE)", (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY);
        this.assertFunction("cast(JSON '\"-Infinity\"' as DOUBLE)", (Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY);
        this.assertInvalidFunction("cast(JSON '\"true\"' as DOUBLE)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON ' 128.9' as DOUBLE)", (Type)DoubleType.DOUBLE, 128.9);
        this.assertFunction("cast(json_extract('{\"x\":1.23}', '$.x') as DOUBLE)", (Type)DoubleType.DOUBLE, 1.23);
        this.assertInvalidCast("cast(JSON '{ \"x\" : 123}' as DOUBLE)");
    }

    @Test
    public void testCastFromDouble() {
        this.assertFunction("cast(cast(null as double) as JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(3.14E0 as JSON)", (Type)JsonType.JSON, "3.14");
        this.assertFunction("cast(nan() as JSON)", (Type)JsonType.JSON, "\"NaN\"");
        this.assertFunction("cast(infinity() as JSON)", (Type)JsonType.JSON, "\"Infinity\"");
        this.assertFunction("cast(-infinity() as JSON)", (Type)JsonType.JSON, "\"-Infinity\"");
    }

    @Test
    public void testCastFromReal() {
        this.assertFunction("cast(cast(null as REAL) as JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(REAL '3.14' as JSON)", (Type)JsonType.JSON, "3.14");
        this.assertFunction("cast(cast(nan() as REAL) as JSON)", (Type)JsonType.JSON, "\"NaN\"");
        this.assertFunction("cast(cast(infinity() as REAL) as JSON)", (Type)JsonType.JSON, "\"Infinity\"");
        this.assertFunction("cast(cast(-infinity() as REAL) as JSON)", (Type)JsonType.JSON, "\"-Infinity\"");
    }

    @Test
    public void testCastToReal() {
        this.assertFunction("cast(JSON 'null' as REAL)", (Type)RealType.REAL, null);
        this.assertFunction("cast(JSON '-128' as REAL)", (Type)RealType.REAL, Float.valueOf(-128.0f));
        this.assertFunction("cast(JSON '128' as REAL)", (Type)RealType.REAL, Float.valueOf(128.0f));
        this.assertFunction("cast(JSON '12345678901234567890' as REAL)", (Type)RealType.REAL, Float.valueOf(1.2345679E19f));
        this.assertFunction("cast(JSON '128.9' as REAL)", (Type)RealType.REAL, Float.valueOf(128.9f));
        this.assertFunction("cast(JSON '1e-46' as REAL)", (Type)RealType.REAL, Float.valueOf(0.0f));
        this.assertFunction("cast(JSON '1e39' as REAL)", (Type)RealType.REAL, Float.valueOf(Float.POSITIVE_INFINITY));
        this.assertFunction("cast(JSON '-1e39' as REAL)", (Type)RealType.REAL, Float.valueOf(Float.NEGATIVE_INFINITY));
        this.assertFunction("cast(JSON 'true' as REAL)", (Type)RealType.REAL, Float.valueOf(1.0f));
        this.assertFunction("cast(JSON 'false' as REAL)", (Type)RealType.REAL, Float.valueOf(0.0f));
        this.assertFunction("cast(JSON '\"128\"' as REAL)", (Type)RealType.REAL, Float.valueOf(128.0f));
        this.assertFunction("cast(JSON '\"12345678901234567890\"' as REAL)", (Type)RealType.REAL, Float.valueOf(1.2345679E19f));
        this.assertFunction("cast(JSON '\"128.9\"' as REAL)", (Type)RealType.REAL, Float.valueOf(128.9f));
        this.assertFunction("cast(JSON '\"NaN\"' as REAL)", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("cast(JSON '\"Infinity\"' as REAL)", (Type)RealType.REAL, Float.valueOf(Float.POSITIVE_INFINITY));
        this.assertFunction("cast(JSON '\"-Infinity\"' as REAL)", (Type)RealType.REAL, Float.valueOf(Float.NEGATIVE_INFINITY));
        this.assertInvalidFunction("cast(JSON '\"true\"' as REAL)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON ' 128.9' as REAL)", (Type)RealType.REAL, Float.valueOf(128.9f));
        this.assertFunction("cast(json_extract('{\"x\":1.23}', '$.x') as REAL)", (Type)RealType.REAL, Float.valueOf(1.23f));
        this.assertInvalidCast("cast(JSON '{ \"x\" : 123}' as REAL)");
    }

    @Test
    public void testCastToDecimal() {
        this.assertFunction("cast(JSON 'null' as DECIMAL(10,3))", (Type)DecimalType.createDecimalType((int)10, (int)3), null);
        this.assertFunction("cast(JSON '128' as DECIMAL(10,3))", (Type)DecimalType.createDecimalType((int)10, (int)3), TestJsonOperators.decimal("128.000"));
        this.assertFunction("cast(cast(DECIMAL '123456789012345678901234567890.12345678' as JSON) as DECIMAL(38,8))", (Type)DecimalType.createDecimalType((int)38, (int)8), TestJsonOperators.decimal("123456789012345678901234567890.12345678"));
        this.assertFunction("cast(JSON '123.456' as DECIMAL(10,5))", (Type)DecimalType.createDecimalType((int)10, (int)5), TestJsonOperators.decimal("123.45600"));
        this.assertFunction("cast(JSON 'true' as DECIMAL(10,5))", (Type)DecimalType.createDecimalType((int)10, (int)5), TestJsonOperators.decimal("1.00000"));
        this.assertFunction("cast(JSON 'false' as DECIMAL(10,5))", (Type)DecimalType.createDecimalType((int)10, (int)5), TestJsonOperators.decimal("0.00000"));
        this.assertInvalidCast("cast(JSON '1234567890123456' as DECIMAL(10,3))", "Cannot cast input json to DECIMAL(10,3)");
        this.assertInvalidCast("cast(JSON '{ \"x\" : 123}' as DECIMAL(10,3))", "Cannot cast '{\"x\":123}' to DECIMAL(10,3)");
        this.assertInvalidCast("cast(JSON '\"abc\"' as DECIMAL(10,3))", "Cannot cast '\"abc\"' to DECIMAL(10,3)");
    }

    @Test
    public void testCastFromDecimal() {
        this.assertFunction("cast(cast(null as decimal(5,2)) as JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(DECIMAL '3.14' as JSON)", (Type)JsonType.JSON, "3.14");
        this.assertFunction("cast(DECIMAL '12345678901234567890.123456789012345678' as JSON)", (Type)JsonType.JSON, "12345678901234567890.123456789012345678");
    }

    @Test
    public void testCastToBoolean() {
        this.assertFunction("cast(JSON 'null' as BOOLEAN)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("cast(JSON '0' as BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast(JSON '128' as BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertInvalidFunction("cast(JSON '12345678901234567890' as BOOLEAN)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON '128.9' as BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(JSON '1e-324' as BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
        this.assertInvalidFunction("cast(JSON '1e309' as BOOLEAN)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON 'true' as BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(JSON 'false' as BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast(JSON '\"True\"' as BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(JSON '\"true\"' as BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(JSON '\"false\"' as BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
        this.assertInvalidFunction("cast(JSON '\"128\"' as BOOLEAN)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(JSON '\"\"' as BOOLEAN)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(JSON ' true' as BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(json_extract('{\"x\":true}', '$.x') as BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertInvalidCast("cast(JSON '{ \"x\" : 123}' as BOOLEAN)");
    }

    @Test
    public void testCastFromBoolean() {
        this.assertFunction("cast(cast (null as boolean) as JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(TRUE as JSON)", (Type)JsonType.JSON, "true");
        this.assertFunction("cast(FALSE as JSON)", (Type)JsonType.JSON, "false");
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("cast(JSON 'null' as VARCHAR)", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("cast(JSON '128' as VARCHAR)", (Type)VarcharType.VARCHAR, "128");
        this.assertFunction("cast(JSON '12345678901234567890' as VARCHAR)", (Type)VarcharType.VARCHAR, "12345678901234567890");
        this.assertFunction("cast(JSON '128.9' as VARCHAR)", (Type)VarcharType.VARCHAR, "128.9");
        this.assertFunction("cast(JSON '1e-324' as VARCHAR)", (Type)VarcharType.VARCHAR, "0.0");
        this.assertFunction("cast(JSON '1e309' as VARCHAR)", (Type)VarcharType.VARCHAR, "Infinity");
        this.assertFunction("cast(JSON '-1e309' as VARCHAR)", (Type)VarcharType.VARCHAR, "-Infinity");
        this.assertFunction("cast(JSON 'true' as VARCHAR)", (Type)VarcharType.VARCHAR, "true");
        this.assertFunction("cast(JSON 'false' as VARCHAR)", (Type)VarcharType.VARCHAR, "false");
        this.assertFunction("cast(JSON '\"test\"' as VARCHAR)", (Type)VarcharType.VARCHAR, "test");
        this.assertFunction("cast(JSON '\"null\"' as VARCHAR)", (Type)VarcharType.VARCHAR, "null");
        this.assertFunction("cast(JSON '\"\"' as VARCHAR)", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("cast(JSON ' \"test\"' as VARCHAR)", (Type)VarcharType.VARCHAR, "test");
        this.assertFunction("cast(json_extract('{\"x\":\"y\"}', '$.x') as VARCHAR)", (Type)VarcharType.VARCHAR, "y");
        this.assertInvalidCast("cast(JSON '{ \"x\" : 123}' as VARCHAR)");
    }

    @Test
    public void testEquals() {
        this.assertFunction("json_parse('{ \"a\": \"1.1\" , \"b\": \"2.3\" , \"c\": { \"d\": \"314E-2\" }}') = json_parse('{ \"a\": \"1.1\" , \"b\": \"2.3\" , \"c\" : { \"d\" : \"314E-2\" }}')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON '[1,2,3]' = JSON '[1,2,3]'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON '{\"a\":1, \"b\":2}' = JSON '{\"b\":2, \"a\":1}'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON '{\"a\":1, \"b\":2}' = CAST(MAP(ARRAY['b','a'], ARRAY[2,1]) AS JSON)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON 'null' = JSON 'null'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON 'true' = JSON 'true'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON '{\"x\":\"y\"}' = JSON '{\"x\":\"y\"}'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON '[1,2,3]' = JSON '[2,3,1]'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON '{\"p_1\": 1, \"p_2\":\"v_2\", \"p_3\":null, \"p_4\":true, \"p_5\": {\"p_1\":1}}' = JSON '{\"p_2\":\"v_2\", \"p_4\":true, \"p_1\": 1, \"p_3\":null, \"p_5\": {\"p_1\":1}}'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEquals() {
        this.assertFunction("JSON '{ \"a\": 1 , \"b\": 2 , \"c\": { \"d\": 3 }}' != JSON '{ \"a\": 1 , \"b\": 2 , \"c\" : { \"d\" : 4 }}'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON '[1,2,3]' != JSON '[1,2,3]'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON '{\"a\":1, \"b\":2}' != JSON '{\"b\":2, \"a\":1}'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON 'null' != JSON 'null'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON 'true' != JSON 'true'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON '{\"x\":\"y\"}' != JSON '{\"x\":\"y\"}'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON '[1,2,3]' != JSON '[2,3,1]'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON '{\"p_1\": 1, \"p_2\":\"v_2\", \"p_3\":null, \"p_4\":true, \"p_5\": {\"p_1\":1}}' != JSON '{\"p_2\":\"v_2\", \"p_4\":true, \"p_1\": 1, \"p_3\":null, \"p_5\": {\"p_1\":1}}'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("JSON 'null' IS DISTINCT FROM JSON 'null'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON '{ \"a\": 1 , \"b\": 2 , \"c\": { \"d\": 3 }}' IS DISTINCT FROM JSON '{ \"a\": 1 , \"b\": 2 , \"c\" : { \"d\" : 4 }}'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON '{ \"a\": 1 , \"b\": 2 , \"c\": { \"d\": 3 }}' IS DISTINCT FROM JSON '{ \"b\": 2 , \"a\": 1 , \"c\": { \"d\": 3 }}'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("JSON '{ \"a\": 1 , \"b\": 2 , \"c\": { \"d\": 3 }}' IS DISTINCT FROM JSON 'null'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("JSON 'null' IS DISTINCT FROM JSON '{ \"a\": 1 , \"b\": 2 , \"c\" : { \"d\" : 4 }}'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testCastFromVarchar() {
        this.assertFunction("cast(cast (null as varchar) as JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast('abc' as JSON)", (Type)JsonType.JSON, "\"abc\"");
        this.assertFunction("cast('\"a\":2' as JSON)", (Type)JsonType.JSON, "\"\\\"a\\\":2\"");
    }

    @Test
    public void testCastFromTimestamp() {
        this.assertFunction("cast(cast (null as timestamp) as JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("CAST(TIMESTAMP '1970-01-01 00:00:01' AS JSON)", (Type)JsonType.JSON, String.format("\"%s\"", DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0)));
    }

    @Test
    public void testCastWithJsonParse() {
        this.assertCastWithJsonParse("[[1,1], [2,2]]", "ARRAY(ARRAY(INTEGER))", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)1), (Object)ImmutableList.of((Object)2, (Object)2)));
        this.assertInvalidCastWithJsonParse("[1, \"abc\"]", "ARRAY(INTEGER)", "Cannot cast to array(integer). Cannot cast 'abc' to INT\n[1, \"abc\"]");
        this.assertCastWithJsonParse("{\"a\"\n:1,  \"b\":\t2}", "MAP(VARCHAR,INTEGER)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2));
        this.assertInvalidTypeWithJsonParse("{\"[1, 1]\":[2, 2]}", "MAP(ARRAY(INTEGER),ARRAY(INTEGER))", "line 1:8: Cannot cast json to map(array(integer), array(integer))");
        this.assertInvalidCastWithJsonParse("{true: false, false:false}", "MAP(BOOLEAN,BOOLEAN)", "Cannot cast to map(boolean, boolean).\n{true: false, false:false}");
        this.assertCastWithJsonParse("{\"a\"  \n  :1,  \"b\":  \t  [2, 3]}", "ROW(a INTEGER, b ARRAY(INTEGER))", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)IntegerType.INTEGER), (Object)RowType.field((String)"b", (Type)new ArrayType((Type)IntegerType.INTEGER)))), ImmutableList.of((Object)1, (Object)ImmutableList.of((Object)2, (Object)3)));
        this.assertCastWithJsonParse("[  1,  [2, 3]  ]", "ROW(INTEGER, ARRAY(INTEGER))", (Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)new ArrayType((Type)IntegerType.INTEGER))), ImmutableList.of((Object)1, (Object)ImmutableList.of((Object)2, (Object)3)));
        this.assertInvalidCastWithJsonParse("{\"a\" :1,  \"b\": {} }", "ROW(a INTEGER, b ARRAY(INTEGER))", "Cannot cast to row(a integer, b array(integer)). Expected a json array, but got {\n{\"a\" :1,  \"b\": {} }");
        this.assertInvalidCastWithJsonParse("[  1,  {}  ]", "ROW(INTEGER, ARRAY(INTEGER))", "Cannot cast to row(integer, array(integer)). Expected a json array, but got {\n[  1,  {}  ]");
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as JSON)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON '128'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON 'true'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON 'false'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON '\"test\"'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON '\"null\"'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON '\"\"'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON 'true'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON 'false'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON '\"True\"'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON '\"true\"'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON '123.456'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON 'true'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON 'false'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON '\"NaN\"'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON '\"Infinity\"'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "JSON '\"-Infinity\"'", (Type)BooleanType.BOOLEAN, false);
    }

    private void assertCastWithJsonParse(String json, String castSqlType, Type expectedType, Object expected) {
        String query = "SELECT CAST(JSON_PARSE(col) AS " + castSqlType + ") FROM (VALUES('" + json + "')) AS t(col)";
        MaterializedResult result = this.runner.execute(query);
        Assert.assertEquals((int)result.getTypes().size(), (int)1);
        Assert.assertEquals(result.getTypes().get(0), (Object)expectedType);
        Assert.assertEquals((Object)result.getOnlyValue(), (Object)expected);
    }

    private void assertInvalidCastWithJsonParse(String json, String castSqlType, String message) {
        String query = "SELECT CAST(JSON_PARSE(col) AS " + castSqlType + ") FROM (VALUES('" + json + "')) AS t(col)";
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> this.runner.execute(query)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT).hasMessage(message);
    }

    private void assertInvalidTypeWithJsonParse(String json, String castSqlType, String message) {
        String query = "SELECT CAST(JSON_PARSE(col) AS " + castSqlType + ") FROM (VALUES('" + json + "')) AS t(col)";
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> this.runner.execute(query)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH).hasMessage(message);
    }
}

