/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.IntArrayBlockBuilder;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.type.AbstractTestType;
import io.prestosql.type.BlockTypeOperators;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRealType
extends AbstractTestType {
    public TestRealType() {
        super((Type)RealType.REAL, Float.class, TestRealType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = RealType.REAL.createBlockBuilder(null, 30);
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(11.11f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(11.11f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(11.11f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(33.33f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(33.33f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(44.44f));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        int bits = ((Long)value).intValue();
        float greaterValue = Float.intBitsToFloat(bits) + 0.1f;
        return (long)Float.floatToRawIntBits(greaterValue);
    }

    @Test
    public void testNaNHash() {
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, 4);
        blockBuilder.writeInt(Float.floatToIntBits(Float.NaN));
        blockBuilder.writeInt(Float.floatToRawIntBits(Float.NaN));
        blockBuilder.writeInt(-4194304);
        blockBuilder.writeInt(2143289344);
        BlockTypeOperators.BlockPositionHashCode hashCodeOperator = this.blockTypeOperators.getHashCodeOperator((Type)RealType.REAL);
        Assert.assertEquals((long)hashCodeOperator.hashCode((Block)blockBuilder, 0), (long)hashCodeOperator.hashCode((Block)blockBuilder, 1));
        Assert.assertEquals((long)hashCodeOperator.hashCode((Block)blockBuilder, 0), (long)hashCodeOperator.hashCode((Block)blockBuilder, 2));
        Assert.assertEquals((long)hashCodeOperator.hashCode((Block)blockBuilder, 0), (long)hashCodeOperator.hashCode((Block)blockBuilder, 3));
    }
}

