/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.SqlDate;
import io.prestosql.spi.type.SqlTimestampWithTimeZone;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.DateTimeTestingUtils;
import io.prestosql.testing.TestingSession;
import io.prestosql.type.IntervalDayTimeType;
import io.prestosql.util.DateTimeZoneIndex;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.annotations.Test;

public class TestTimestampWithTimeZone
extends AbstractTestFunctions {
    private static final TimeZoneKey TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)369L);
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);
    private static final TimeZoneKey WEIRD_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)429L);
    private static final DateTimeZone WEIRD_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)WEIRD_TIME_ZONE_KEY);
    private static final TimeZoneKey BERLIN_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin");
    private static final DateTimeZone BERLIN_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)BERLIN_TIME_ZONE_KEY);

    public TestTimestampWithTimeZone() {
        super(TestingSession.testSessionBuilder().setTimeZoneKey(TIME_ZONE_KEY).build());
    }

    @Test
    public void testLiteral() {
        this.assertFunction("TIMESTAMP '2001-01-02 03:04:05.321 +07:09'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 2, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-01-02 03:04:05 +07:09'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), SqlTimestampWithTimeZone.newInstance((int)0, (long)new DateTime(2001, 1, 2, 3, 4, 5, 0, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-01-02 03:04 +07:09'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), SqlTimestampWithTimeZone.newInstance((int)0, (long)new DateTime(2001, 1, 2, 3, 4, 0, 0, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-01-02 +07:09'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), SqlTimestampWithTimeZone.newInstance((int)0, (long)new DateTime(2001, 1, 2, 0, 0, 0, 0, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-2 3:4:5.321+07:09'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 2, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-2 3:4:5+07:09'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), SqlTimestampWithTimeZone.newInstance((int)0, (long)new DateTime(2001, 1, 2, 3, 4, 5, 0, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-2 3:4+07:09'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), SqlTimestampWithTimeZone.newInstance((int)0, (long)new DateTime(2001, 1, 2, 3, 4, 0, 0, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-2+07:09'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), SqlTimestampWithTimeZone.newInstance((int)0, (long)new DateTime(2001, 1, 2, 0, 0, 0, 0, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-01-02 03:04:05.321 Europe/Berlin'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 2, 3, 4, 5, 321, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-01-02 03:04:05 Europe/Berlin'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), SqlTimestampWithTimeZone.newInstance((int)0, (long)new DateTime(2001, 1, 2, 3, 4, 5, 0, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-01-02 03:04 Europe/Berlin'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), SqlTimestampWithTimeZone.newInstance((int)0, (long)new DateTime(2001, 1, 2, 3, 4, 0, 0, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-01-02 Europe/Berlin'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), SqlTimestampWithTimeZone.newInstance((int)0, (long)new DateTime(2001, 1, 2, 0, 0, 0, 0, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '12001-01-02 03:04:05.321 Europe/Berlin'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(12001, 1, 2, 3, 4, 5, 321, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '+12001-01-02 03:04:05.321 Europe/Berlin'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(12001, 1, 2, 3, 4, 5, 321, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '-12001-01-02 03:04:05.321 Europe/Berlin'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(-12001, 1, 2, 3, 4, 5, 321, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertInvalidFunction("TIMESTAMP '123001-01-02 03:04:05.321 Europe/Berlin'", (ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, "line 1:1: '123001-01-02 03:04:05.321 Europe/Berlin' is not a valid timestamp literal");
        this.assertInvalidFunction("TIMESTAMP '+123001-01-02 03:04:05.321 Europe/Berlin'", (ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, "line 1:1: '+123001-01-02 03:04:05.321 Europe/Berlin' is not a valid timestamp literal");
        this.assertInvalidFunction("TIMESTAMP '-123001-01-02 03:04:05.321 Europe/Berlin'", (ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, "line 1:1: '-123001-01-02 03:04:05.321 Europe/Berlin' is not a valid timestamp literal");
    }

    @Test
    public void testSubtract() {
        this.functionAssertions.assertFunctionString("TIMESTAMP '2017-03-30 14:15:16.432 +07:09' - TIMESTAMP '2016-03-29 03:04:05.321 +08:09'", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, "366 12:11:11.111");
        this.functionAssertions.assertFunctionString("TIMESTAMP '2016-03-29 03:04:05.321 +08:09' - TIMESTAMP '2017-03-30 14:15:16.432 +07:09'", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, "-366 12:11:11.111");
    }

    @Test
    public void testEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' = TIMESTAMP '2001-1-22 03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' = TIMESTAMP '2001-1-22 02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' = TIMESTAMP '2001-1-22 02:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' = TIMESTAMP '2001-1-22 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' = TIMESTAMP '2001-1-22 03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' = TIMESTAMP '2001-1-22 02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' = TIMESTAMP '2001-1-22 02:04:05.333'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' = TIMESTAMP '2001-1-11 +07:09'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <> TIMESTAMP '2001-1-22 03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <> TIMESTAMP '2001-1-22 02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <> TIMESTAMP '2001-1-22 02:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' <> TIMESTAMP '2001-1-11 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <> TIMESTAMP '2001-1-22 03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <> TIMESTAMP '2001-1-22 02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <> TIMESTAMP '2001-1-22 02:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' <> TIMESTAMP '2001-1-22 +07:09'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' < TIMESTAMP '2001-1-22 03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' < TIMESTAMP '2001-1-22 02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' < TIMESTAMP '2001-1-22 02:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' < TIMESTAMP '2001-1-23 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' < TIMESTAMP '2001-1-22 03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' < TIMESTAMP '2001-1-22 02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' < TIMESTAMP '2001-1-22 02:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' < TIMESTAMP '2001-1-22 03:04:05 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' < TIMESTAMP '2001-1-22 02:04:05 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' < TIMESTAMP '2001-1-22 02:04:05'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' < TIMESTAMP '2001-1-22 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' < TIMESTAMP '2001-1-20 +07:09'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <= TIMESTAMP '2001-1-22 03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <= TIMESTAMP '2001-1-22 02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <= TIMESTAMP '2001-1-22 02:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <= TIMESTAMP '2001-1-22 03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <= TIMESTAMP '2001-1-22 02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <= TIMESTAMP '2001-1-22 02:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' <= TIMESTAMP '2001-1-23 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' <= TIMESTAMP '2001-1-22 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <= TIMESTAMP '2001-1-22 03:04:05 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <= TIMESTAMP '2001-1-22 02:04:05 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' <= TIMESTAMP '2001-1-22 02:04:05'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' <= TIMESTAMP '2001-1-20 +07:09'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' > TIMESTAMP '2001-1-22 03:04:05.111 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' > TIMESTAMP '2001-1-22 02:04:05.111 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' > TIMESTAMP '2001-1-22 02:04:05.111'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' > TIMESTAMP '2001-1-11 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' > TIMESTAMP '2001-1-22 03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' > TIMESTAMP '2001-1-22 02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' > TIMESTAMP '2001-1-22 02:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' > TIMESTAMP '2001-1-22 03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' > TIMESTAMP '2001-1-22 02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' > TIMESTAMP '2001-1-22 02:04:05.333'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' > TIMESTAMP '2001-1-22 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' > TIMESTAMP '2001-1-23 +07:09'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' >= TIMESTAMP '2001-1-22 03:04:05.111 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' >= TIMESTAMP '2001-1-22 02:04:05.111 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' >= TIMESTAMP '2001-1-22 02:04:05.111'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' >= TIMESTAMP '2001-1-22 03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' >= TIMESTAMP '2001-1-22 02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' >= TIMESTAMP '2001-1-22 02:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' >= TIMESTAMP '2001-1-11 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' >= TIMESTAMP '2001-1-22 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' >= TIMESTAMP '2001-1-22 03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' >= TIMESTAMP '2001-1-22 02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' >= TIMESTAMP '2001-1-22 02:04:05.333'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 +07:09' >= TIMESTAMP '2001-1-23 +07:09'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 03:04:05.111 +07:09' and TIMESTAMP '2001-1-22 03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.111 +06:09' and TIMESTAMP '2001-1-22 02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.111' and TIMESTAMP '2001-1-22 02:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 03:04:05.321 +07:09' and TIMESTAMP '2001-1-22 03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.321 +06:09' and TIMESTAMP '2001-1-22 02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.321' and TIMESTAMP '2001-1-22 02:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 03:04:05.111 +07:09' and TIMESTAMP '2001-1-22 03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.111 +06:09' and TIMESTAMP '2001-1-22 02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.111' and TIMESTAMP '2001-1-22 02:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 03:04:05.321 +07:09' and TIMESTAMP '2001-1-22 03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.321 +06:09' and TIMESTAMP '2001-1-22 02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.321' and TIMESTAMP '2001-1-22 02:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 03:04:05.322 +07:09' and TIMESTAMP '2001-1-22 03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.322 +06:09' and TIMESTAMP '2001-1-22 02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.322' and TIMESTAMP '2001-1-22 02:04:05.333'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 03:04:05.311 +07:09' and TIMESTAMP '2001-1-22 03:04:05.312 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.311 +06:09' and TIMESTAMP '2001-1-22 02:04:05.312 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.311' and TIMESTAMP '2001-1-22 02:04:05.312'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 03:04:05.333 +07:09' and TIMESTAMP '2001-1-22 03:04:05.111 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.333 +06:09' and TIMESTAMP '2001-1-22 02:04:05.111 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +07:09' between TIMESTAMP '2001-1-22 02:04:05.333' and TIMESTAMP '2001-1-22 02:04:05.111'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastToDate() {
        long millis = new DateTime(2001, 1, 22, 0, 0, DateTimeZone.UTC).getMillis();
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321 +07:09' as date)", (Type)DateType.DATE, new SqlDate((int)TimeUnit.MILLISECONDS.toDays(millis)));
    }

    @Test
    public void testCastToTime() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321 +07:09' as time)", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321));
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2001-1-22 03:04:05.321 +07:09' as time)", (Type)TimeType.TIME, "03:04:05.321");
    }

    @Test
    public void testCastToTimestamp() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321 +07:09' as timestamp)", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321));
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321 Pacific/Bougainville' as timestamp)", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321));
    }

    @Test
    public void testCastToSlice() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321 +07:09' as varchar)", (Type)VarcharType.VARCHAR, "2001-01-22 03:04:05.321 +07:09");
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05 +07:09' as varchar)", (Type)VarcharType.VARCHAR, "2001-01-22 03:04:05 +07:09");
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04 +07:09' as varchar)", (Type)VarcharType.VARCHAR, "2001-01-22 03:04:00 +07:09");
        this.assertFunction("cast(TIMESTAMP '2001-1-22 +07:09' as varchar)", (Type)VarcharType.VARCHAR, "2001-01-22 00:00:00 +07:09");
    }

    @Test
    public void testCastFromSlice() {
        this.assertFunction("cast('2001-1-22 03:04:05.321' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22 03:04:05' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 5, 0, DATE_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22 03:04' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 0, 0, DATE_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 0, 0, 0, 0, DATE_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22 03:04:05.321 +07:09' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22 03:04:05 +07:09' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 5, 0, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22 03:04 +07:09' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 0, 0, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22 +07:09' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 0, 0, 0, 0, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22 03:04:05.321 Europe/Berlin' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 5, 321, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22 03:04:05 Europe/Berlin' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 5, 0, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22 03:04 Europe/Berlin' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 0, 0, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22 Europe/Berlin' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 0, 0, 0, 0, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("cast('\n\t 2001-1-22 03:04:05.321 Europe/Berlin' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 5, 321, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("cast('2001-1-22 03:04:05.321 Europe/Berlin \t\n' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 5, 321, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
        this.assertFunction("cast('\n\t 2001-1-22 03:04:05.321 Europe/Berlin \t\n' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 5, 321, BERLIN_ZONE).getMillis(), (int)0, (TimeZoneKey)BERLIN_TIME_ZONE_KEY));
    }

    @Test
    public void testGreatest() {
        this.assertFunction("greatest(TIMESTAMP '2002-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 01:04:05.321 +02:09', TIMESTAMP '2000-01-02 01:04:05.321 +02:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2002, 1, 2, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("greatest(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 04:04:05.321 +10:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 2, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testLeast() {
        this.assertFunction("least(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 01:04:05.321 +02:09', TIMESTAMP '2002-01-02 01:04:05.321 +02:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 2, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("least(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 01:04:05.321 +02:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 2, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as TIMESTAMP WITH TIME ZONE)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "TIMESTAMP '2001-01-02 01:04:05.321 +02:09'", (Type)BooleanType.BOOLEAN, false);
    }
}

