/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import io.prestosql.util.LongBigArrayFIFOQueue;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLongBigArrayFIFOQueue {
    @Test
    public void testEnqueueDequeue() {
        long i;
        LongBigArrayFIFOQueue queue = new LongBigArrayFIFOQueue();
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertEquals((int)queue.size(), (int)0);
        Assert.assertEquals((long)queue.longSize(), (long)0L);
        for (i = 1L; i <= 100L; ++i) {
            queue.enqueue(i);
            Assert.assertFalse((boolean)queue.isEmpty());
            Assert.assertEquals((long)queue.lastLong(), (long)i);
            Assert.assertEquals((long)queue.size(), (long)i);
            Assert.assertEquals((long)queue.longSize(), (long)i);
        }
        Assert.assertEquals((long)queue.firstLong(), (long)1L);
        Assert.assertEquals((long)queue.lastLong(), (long)100L);
        for (i = 1L; i <= 100L; ++i) {
            Assert.assertEquals((long)queue.size(), (long)(100L - i + 1L));
            Assert.assertEquals((long)queue.longSize(), (long)(100L - i + 1L));
            Assert.assertEquals((long)queue.dequeueLong(), (long)i);
        }
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertEquals((int)queue.size(), (int)0);
        Assert.assertEquals((long)queue.longSize(), (long)0L);
    }

    @Test
    public void testReverseEnqueueDequeue() {
        long i;
        LongBigArrayFIFOQueue queue = new LongBigArrayFIFOQueue();
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertEquals((int)queue.size(), (int)0);
        Assert.assertEquals((long)queue.longSize(), (long)0L);
        for (i = 1L; i <= 100L; ++i) {
            queue.enqueueFirst(i);
            Assert.assertFalse((boolean)queue.isEmpty());
            Assert.assertEquals((long)queue.firstLong(), (long)i);
            Assert.assertEquals((long)queue.size(), (long)i);
            Assert.assertEquals((long)queue.longSize(), (long)i);
        }
        Assert.assertEquals((long)queue.firstLong(), (long)100L);
        Assert.assertEquals((long)queue.lastLong(), (long)1L);
        for (i = 1L; i <= 100L; ++i) {
            Assert.assertEquals((long)queue.size(), (long)(100L - i + 1L));
            Assert.assertEquals((long)queue.longSize(), (long)(100L - i + 1L));
            Assert.assertEquals((long)queue.dequeueLastLong(), (long)i);
        }
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertEquals((int)queue.size(), (int)0);
        Assert.assertEquals((long)queue.longSize(), (long)0L);
    }

    @Test
    public void testResize() {
        long i;
        int initialCapacity = 1;
        LongBigArrayFIFOQueue queue = new LongBigArrayFIFOQueue((long)initialCapacity);
        for (i = 0L; i < 1000000L; ++i) {
            queue.enqueue(i);
        }
        for (i = 0L; i < 1000000L; ++i) {
            Assert.assertEquals((long)queue.dequeueLong(), (long)i);
        }
        queue.trim();
        for (i = 0L; i < 1000000L; ++i) {
            queue.enqueue(i);
        }
        for (i = 0L; i < 1000000L; ++i) {
            Assert.assertEquals((long)queue.dequeueLong(), (long)i);
        }
    }
}

