/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql;

import io.airlift.units.DataSize;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;

public class ExceededSpillLimitException
extends PrestoException {
    public static ExceededSpillLimitException exceededLocalLimit(DataSize maxSpill) {
        return new ExceededSpillLimitException(String.format("Query exceeded local spill limit of %s", maxSpill));
    }

    public static ExceededSpillLimitException exceededPerQueryLocalLimit(DataSize maxSpill) {
        return new ExceededSpillLimitException(String.format("Query exceeded per-query local spill limit of %s", maxSpill));
    }

    private ExceededSpillLimitException(String message) {
        super((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_SPILL_LIMIT, message);
    }
}

