/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import io.prestosql.Session;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.SimpleStatsRule;
import io.prestosql.cost.StatsNormalizer;
import io.prestosql.cost.StatsProvider;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.Patterns;
import java.util.Optional;

public class EnforceSingleRowStatsRule
extends SimpleStatsRule<EnforceSingleRowNode> {
    private static final Pattern<EnforceSingleRowNode> PATTERN = Patterns.enforceSingleRow();

    public EnforceSingleRowStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<EnforceSingleRowNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(EnforceSingleRowNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        return Optional.of(PlanNodeStatsEstimate.buildFrom(sourceStats.getStats(node.getSource())).setOutputRowCount(1.0).build());
    }
}

