/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import io.prestosql.Session;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.ScalarStatsCalculator;
import io.prestosql.cost.SimpleStatsRule;
import io.prestosql.cost.StatsNormalizer;
import io.prestosql.cost.StatsProvider;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.Expression;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ProjectStatsRule
extends SimpleStatsRule<ProjectNode> {
    private static final Pattern<ProjectNode> PATTERN = Patterns.project();
    private final ScalarStatsCalculator scalarStatsCalculator;

    public ProjectStatsRule(ScalarStatsCalculator scalarStatsCalculator, StatsNormalizer normalizer) {
        super(normalizer);
        this.scalarStatsCalculator = Objects.requireNonNull(scalarStatsCalculator, "scalarStatsCalculator is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(ProjectNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(node.getSource());
        PlanNodeStatsEstimate.Builder calculatedStats = PlanNodeStatsEstimate.builder().setOutputRowCount(sourceStats.getOutputRowCount());
        for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
            calculatedStats.addSymbolStatistics(entry.getKey(), this.scalarStatsCalculator.calculate(entry.getValue(), sourceStats, session, types));
        }
        return Optional.of(calculatedStats.build());
    }
}

