/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.dispatcher;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.dispatcher.DispatchInfo;
import io.prestosql.dispatcher.DispatchQuery;
import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.execution.Input;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.QueryStats;
import io.prestosql.execution.StateMachine;
import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.operator.BlockedReason;
import io.prestosql.operator.OperatorStats;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.DynamicFilterService;
import io.prestosql.spi.ErrorCode;
import io.prestosql.spi.PrestoWarning;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.eventlistener.RoutineInfo;
import io.prestosql.spi.eventlistener.StageGcStatistics;
import io.prestosql.spi.eventlistener.TableInfo;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.util.Failures;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class FailedDispatchQuery
implements DispatchQuery {
    private final QueryInfo fullQueryInfo;
    private final BasicQueryInfo basicQueryInfo;
    private final Session session;
    private final Executor executor;
    private final DispatchInfo dispatchInfo;

    public FailedDispatchQuery(Session session, String query, Optional<String> preparedQuery, URI self, Optional<ResourceGroupId> resourceGroup, Throwable cause, Executor executor) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(self, "self is null");
        Objects.requireNonNull(resourceGroup, "resourceGroup is null");
        Objects.requireNonNull(cause, "cause is null");
        Objects.requireNonNull(executor, "executor is null");
        this.fullQueryInfo = FailedDispatchQuery.immediateFailureQueryInfo(session, query, preparedQuery, self, resourceGroup, cause);
        this.basicQueryInfo = new BasicQueryInfo(this.fullQueryInfo);
        this.session = Objects.requireNonNull(session, "session is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.dispatchInfo = DispatchInfo.failed(this.fullQueryInfo.getFailureInfo(), this.basicQueryInfo.getQueryStats().getElapsedTime(), this.basicQueryInfo.getQueryStats().getQueuedTime());
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.basicQueryInfo;
    }

    @Override
    public QueryInfo getFullQueryInfo() {
        return this.fullQueryInfo;
    }

    @Override
    public QueryState getState() {
        return this.fullQueryInfo.getState();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public ListenableFuture<?> getDispatchedFuture() {
        return Futures.immediateFuture(null);
    }

    @Override
    public DispatchInfo getDispatchInfo() {
        return this.dispatchInfo;
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.executor.execute(() -> stateChangeListener.stateChanged(QueryState.FAILED));
    }

    @Override
    public void startWaitingForResources() {
    }

    @Override
    public void fail(Throwable throwable) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void pruneInfo() {
    }

    @Override
    public QueryId getQueryId() {
        return this.basicQueryInfo.getQueryId();
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public Optional<ErrorCode> getErrorCode() {
        return Optional.ofNullable(this.basicQueryInfo.getErrorCode());
    }

    @Override
    public void recordHeartbeat() {
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.basicQueryInfo.getQueryStats().getEndTime();
    }

    @Override
    public DateTime getCreateTime() {
        return this.basicQueryInfo.getQueryStats().getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.getEndTime();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return Optional.ofNullable(this.basicQueryInfo.getQueryStats().getEndTime());
    }

    @Override
    public Duration getTotalCpuTime() {
        return new Duration(0.0, TimeUnit.MILLISECONDS);
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        return DataSize.ofBytes((long)0L);
    }

    @Override
    public DataSize getUserMemoryReservation() {
        return DataSize.ofBytes((long)0L);
    }

    private static QueryInfo immediateFailureQueryInfo(Session session, String query, Optional<String> preparedQuery, URI self, Optional<ResourceGroupId> resourceGroupId, Throwable throwable) {
        ExecutionFailureInfo failureCause = Failures.toFailure(throwable);
        QueryInfo queryInfo = new QueryInfo(session.getQueryId(), session.toSessionRepresentation(), QueryState.FAILED, LocalMemoryManager.GENERAL_POOL, false, self, (List<String>)ImmutableList.of(), query, preparedQuery, FailedDispatchQuery.immediateFailureQueryStats(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), (Map<String, SelectedRole>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), false, null, Optional.empty(), failureCause, failureCause.getErrorCode(), (List<PrestoWarning>)ImmutableList.of(), (Set<Input>)ImmutableSet.of(), Optional.empty(), (List<TableInfo>)ImmutableList.of(), (List<RoutineInfo>)ImmutableList.of(), true, resourceGroupId, Optional.empty());
        return queryInfo;
    }

    private static QueryStats immediateFailureQueryStats() {
        DateTime now = DateTime.now();
        return new QueryStats(now, now, now, now, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), 0, 0, 0, 0, 0, 0, 0, 0, 0.0, DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), false, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), false, (Set<BlockedReason>)ImmutableSet.of(), DataSize.ofBytes((long)0L), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)0L), 0L, DataSize.ofBytes((long)0L), 0L, DataSize.ofBytes((long)0L), 0L, DataSize.ofBytes((long)0L), 0L, DataSize.ofBytes((long)0L), (List<StageGcStatistics>)ImmutableList.of(), DynamicFilterService.DynamicFiltersStats.EMPTY, (List<OperatorStats>)ImmutableList.of());
    }
}

