/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.eventlistener;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.prestosql.eventlistener.EventListenerConfig;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.eventlistener.EventListener;
import io.prestosql.spi.eventlistener.EventListenerFactory;
import io.prestosql.spi.eventlistener.QueryCompletedEvent;
import io.prestosql.spi.eventlistener.QueryCreatedEvent;
import io.prestosql.spi.eventlistener.SplitCompletedEvent;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class EventListenerManager {
    private static final Logger log = Logger.get(EventListenerManager.class);
    private static final File CONFIG_FILE = new File("etc/event-listener.properties");
    private static final String EVENT_LISTENER_NAME_PROPERTY = "event-listener.name";
    private final List<File> configFiles;
    private final Map<String, EventListenerFactory> eventListenerFactories = new ConcurrentHashMap<String, EventListenerFactory>();
    private final List<EventListener> providedEventListeners = Collections.synchronizedList(new ArrayList());
    private final AtomicReference<List<EventListener>> configuredEventListeners = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final AtomicBoolean loading = new AtomicBoolean(false);

    @Inject
    public EventListenerManager(EventListenerConfig config) {
        this.configFiles = ImmutableList.copyOf(config.getEventListenerFiles());
    }

    public void addEventListenerFactory(EventListenerFactory eventListenerFactory) {
        Objects.requireNonNull(eventListenerFactory, "eventListenerFactory is null");
        if (this.eventListenerFactories.putIfAbsent(eventListenerFactory.getName(), eventListenerFactory) != null) {
            throw new IllegalArgumentException(String.format("Event listener factory '%s' is already registered", eventListenerFactory.getName()));
        }
    }

    public void addEventListener(EventListener eventListener) {
        Objects.requireNonNull(eventListener, "EventListener is null");
        this.providedEventListeners.add(eventListener);
    }

    public void loadEventListeners() {
        Preconditions.checkState((boolean)this.loading.compareAndSet(false, true), (Object)"Event listeners already loaded");
        this.configuredEventListeners.set((List<EventListener>)ImmutableList.builder().addAll(this.providedEventListeners).addAll(this.configuredEventListeners()).build());
    }

    private List<EventListener> configuredEventListeners() {
        ImmutableList configFiles = this.configFiles;
        if (configFiles.isEmpty()) {
            if (!CONFIG_FILE.exists()) {
                return ImmutableList.of();
            }
            configFiles = ImmutableList.of((Object)CONFIG_FILE);
        }
        return (List)configFiles.stream().map(this::createEventListener).collect(ImmutableList.toImmutableList());
    }

    private EventListener createEventListener(File configFile) {
        EventListener eventListener;
        log.info("-- Loading event listener %s --", new Object[]{configFile});
        configFile = configFile.getAbsoluteFile();
        Map<String, String> properties = EventListenerManager.loadEventListenerProperties(configFile);
        String name = properties.remove(EVENT_LISTENER_NAME_PROPERTY);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"EventListener plugin configuration for %s does not contain %s", (Object)configFile, (Object)EVENT_LISTENER_NAME_PROPERTY);
        EventListenerFactory eventListenerFactory = this.eventListenerFactories.get(name);
        Preconditions.checkArgument((eventListenerFactory != null ? 1 : 0) != 0, (String)"Event listener factory '%s' is not registered. Available factories: %s", (Object)name, this.eventListenerFactories.keySet());
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(eventListenerFactory.getClass().getClassLoader());){
            eventListener = eventListenerFactory.create(properties);
        }
        log.info("-- Loaded event listener %s --", new Object[]{configFile});
        return eventListener;
    }

    private static Map<String, String> loadEventListenerProperties(File configFile) {
        try {
            return new HashMap<String, String>(ConfigurationLoader.loadPropertiesFrom((String)configFile.getPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read configuration file: " + configFile, e);
        }
    }

    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        for (EventListener listener : this.configuredEventListeners.get()) {
            try {
                listener.queryCompleted(queryCompletedEvent);
            }
            catch (Throwable e) {
                log.warn(e, "Failed to publish QueryCompletedEvent for query %s", new Object[]{queryCompletedEvent.getMetadata().getQueryId()});
            }
        }
    }

    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        for (EventListener listener : this.configuredEventListeners.get()) {
            try {
                listener.queryCreated(queryCreatedEvent);
            }
            catch (Throwable e) {
                log.warn(e, "Failed to publish QueryCreatedEvent for query %s", new Object[]{queryCreatedEvent.getMetadata().getQueryId()});
            }
        }
    }

    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        for (EventListener listener : this.configuredEventListeners.get()) {
            try {
                listener.splitCompleted(splitCompletedEvent);
            }
            catch (Throwable e) {
                log.warn(e, "Failed to publish SplitCompletedEvent for query %s", new Object[]{splitCompletedEvent.getQueryId()});
            }
        }
    }
}

