/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.SetSchemaAuthorization;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class SetSchemaAuthorizationTask
implements DataDefinitionTask<SetSchemaAuthorization> {
    @Override
    public String getName() {
        return "SET SCHEMA AUTHORIZATION";
    }

    @Override
    public ListenableFuture<?> execute(SetSchemaAuthorization statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        String catalog = MetadataUtil.getSessionCatalog(metadata, session, (Node)statement);
        CatalogSchemaName source = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSource()));
        if (!metadata.schemaExists(session, source)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)statement, "Schema '%s' does not exist", source);
        }
        PrestoPrincipal principal = MetadataUtil.createPrincipal(statement.getPrincipal());
        if (principal.getType() == PrincipalType.ROLE && !metadata.listRoles(session, catalog).contains(principal.getName())) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND, (Node)statement, "Role '%s' does not exist", principal.getName());
        }
        accessControl.checkCanSetSchemaAuthorization(session.toSecurityContext(), source, principal);
        metadata.setSchemaAuthorization(session, source, principal);
        return Futures.immediateFuture(null);
    }
}

