/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.resourcegroups;

import com.google.common.base.Preconditions;
import io.prestosql.execution.resourcegroups.UpdateablePriorityQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

final class StochasticPriorityQueue<E>
implements UpdateablePriorityQueue<E> {
    private final Map<E, Node<E>> index = new HashMap<E, Node<E>>();
    private Node<E> root;

    StochasticPriorityQueue() {
    }

    @Override
    public boolean addOrUpdate(E element, long priority) {
        Preconditions.checkArgument((priority > 0L ? 1 : 0) != 0, (Object)"priority must be positive");
        if (this.root == null) {
            this.root = new Node(Optional.empty(), element);
            this.root.setTickets(priority);
            this.index.put(element, this.root);
            return true;
        }
        Node<E> node = this.index.get(element);
        if (node != null) {
            node.setTickets(priority);
            return false;
        }
        node = this.root.addNode(element, priority);
        this.index.put(element, node);
        return true;
    }

    @Override
    public boolean contains(E element) {
        return this.index.containsKey(element);
    }

    @Override
    public boolean remove(E element) {
        Node<E> node = this.index.remove(element);
        if (node == null) {
            return false;
        }
        if (node.isLeaf() && node.equals(this.root)) {
            this.root = null;
        } else if (node.isLeaf()) {
            node.remove();
        } else {
            Node<E> leaf = this.root.findLeaf();
            leaf.remove();
            node.setTickets(leaf.getTickets());
            node.setValue(leaf.getValue());
            this.index.put(leaf.getValue(), node);
        }
        return true;
    }

    @Override
    public E poll() {
        if (this.root == null) {
            return null;
        }
        long winningTicket = ThreadLocalRandom.current().nextLong(this.root.getTotalTickets());
        Node<E> candidate = this.root;
        while (!candidate.isLeaf()) {
            long leftTickets = candidate.getLeft().map(Node::getTotalTickets).orElse(0L);
            if (winningTicket < leftTickets) {
                candidate = candidate.getLeft().get();
                continue;
            }
            if ((winningTicket -= leftTickets) < candidate.getTickets()) break;
            winningTicket -= candidate.getTickets();
            Preconditions.checkState((boolean)candidate.getRight().isPresent(), (Object)"Expected right node to contain the winner, but it does not exist");
            candidate = candidate.getRight().get();
        }
        Preconditions.checkState((winningTicket < candidate.getTickets() ? 1 : 0) != 0, (Object)"Inconsistent winner");
        E value = candidate.getValue();
        this.remove(value);
        return value;
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.index.size();
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.index.keySet().iterator();
    }

    private static final class Node<E> {
        private Optional<Node<E>> parent;
        private E value;
        private Optional<Node<E>> left = Optional.empty();
        private Optional<Node<E>> right = Optional.empty();
        private long tickets;
        private long totalTickets;
        private int descendants;

        private Node(Optional<Node<E>> parent, E value) {
            this.parent = parent;
            this.value = value;
        }

        public E getValue() {
            return this.value;
        }

        public void setValue(E value) {
            this.value = value;
        }

        public Optional<Node<E>> getLeft() {
            return this.left;
        }

        public Optional<Node<E>> getRight() {
            return this.right;
        }

        public long getTotalTickets() {
            return this.totalTickets;
        }

        public long getTickets() {
            return this.tickets;
        }

        public void setTickets(long tickets) {
            Preconditions.checkArgument((tickets > 0L ? 1 : 0) != 0, (Object)"tickets must be positive");
            if (tickets == this.tickets) {
                return;
            }
            long ticketDelta = tickets - this.tickets;
            Node node = this;
            while (node != null) {
                node.totalTickets += ticketDelta;
                node = node.parent.orElse(null);
            }
            this.tickets = tickets;
        }

        public boolean isLeaf() {
            return this.left.isEmpty() && this.right.isEmpty();
        }

        public Node<E> findLeaf() {
            int leftDecendants = this.left.map(node -> node.descendants).orElse(0);
            int rightDecendants = this.right.map(node -> node.descendants).orElse(0);
            if (leftDecendants == 0 && rightDecendants == 0) {
                return this.left.orElse(this.right.orElse(this));
            }
            if (leftDecendants > rightDecendants) {
                return this.left.get().findLeaf();
            }
            if (rightDecendants > leftDecendants) {
                return this.right.get().findLeaf();
            }
            Preconditions.checkState((boolean)this.left.isPresent(), (Object)"Left child missing");
            return this.left.get().findLeaf();
        }

        public void remove() {
            Preconditions.checkState((boolean)this.parent.isPresent(), (Object)"Cannot remove root node");
            Preconditions.checkState((boolean)this.isLeaf(), (Object)"Can only remove leaf nodes");
            Node parent = this.parent.get();
            if (parent.getRight().map(node -> node.equals(this)).orElse(false).booleanValue()) {
                parent.right = Optional.empty();
            } else {
                Preconditions.checkState((boolean)parent.getLeft().map(node -> node.equals(this)).orElse(false), (Object)"Inconsistent parent pointer");
                parent.left = Optional.empty();
            }
            while (parent != null) {
                --parent.descendants;
                parent.totalTickets -= this.tickets;
                parent = parent.parent.orElse(null);
            }
            this.parent = Optional.empty();
        }

        public Node<E> addNode(E value, long tickets) {
            ++this.descendants;
            if (this.left.isPresent() && this.right.isPresent()) {
                if (this.left.get().descendants < this.right.get().descendants) {
                    return this.left.get().addNode(value, tickets);
                }
                return this.right.get().addNode(value, tickets);
            }
            Node<E> child = new Node<E>(Optional.of(this), value);
            if (this.left.isPresent()) {
                this.right = Optional.of(child);
            } else {
                this.left = Optional.of(child);
            }
            child.setTickets(tickets);
            return child;
        }
    }
}

