/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import io.airlift.configuration.Config;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import java.util.Locale;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"node-scheduler.location-aware-scheduling-enabled", "node-scheduler.multiple-tasks-per-node-enabled"})
public class NodeSchedulerConfig {
    private int minCandidates = 10;
    private boolean includeCoordinator = true;
    private int maxSplitsPerNode = 100;
    private int maxPendingSplitsPerTask = 10;
    private NodeSchedulerPolicy nodeSchedulerPolicy = NodeSchedulerPolicy.UNIFORM;
    private boolean optimizedLocalScheduling = true;

    @NotNull
    public NodeSchedulerPolicy getNodeSchedulerPolicy() {
        return this.nodeSchedulerPolicy;
    }

    @LegacyConfig(value={"node-scheduler.network-topology"})
    @Config(value="node-scheduler.policy")
    public NodeSchedulerConfig setNodeSchedulerPolicy(String nodeSchedulerPolicy) {
        this.nodeSchedulerPolicy = NodeSchedulerConfig.toNodeSchedulerPolicy(nodeSchedulerPolicy);
        return this;
    }

    private static NodeSchedulerPolicy toNodeSchedulerPolicy(String nodeSchedulerPolicy) {
        switch (nodeSchedulerPolicy.toLowerCase(Locale.ENGLISH)) {
            case "legacy": 
            case "uniform": {
                return NodeSchedulerPolicy.UNIFORM;
            }
            case "flat": 
            case "topology": {
                return NodeSchedulerPolicy.TOPOLOGY;
            }
        }
        throw new IllegalArgumentException("Unknown node scheduler policy: " + nodeSchedulerPolicy);
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinCandidates() {
        return this.minCandidates;
    }

    @Config(value="node-scheduler.min-candidates")
    public NodeSchedulerConfig setMinCandidates(int candidates) {
        this.minCandidates = candidates;
        return this;
    }

    public boolean isIncludeCoordinator() {
        return this.includeCoordinator;
    }

    @Config(value="node-scheduler.include-coordinator")
    public NodeSchedulerConfig setIncludeCoordinator(boolean includeCoordinator) {
        this.includeCoordinator = includeCoordinator;
        return this;
    }

    @Config(value="node-scheduler.max-pending-splits-per-task")
    @LegacyConfig(value={"node-scheduler.max-pending-splits-per-node-per-task", "node-scheduler.max-pending-splits-per-node-per-stage"})
    public NodeSchedulerConfig setMaxPendingSplitsPerTask(int maxPendingSplitsPerTask) {
        this.maxPendingSplitsPerTask = maxPendingSplitsPerTask;
        return this;
    }

    public int getMaxPendingSplitsPerTask() {
        return this.maxPendingSplitsPerTask;
    }

    public int getMaxSplitsPerNode() {
        return this.maxSplitsPerNode;
    }

    @Config(value="node-scheduler.max-splits-per-node")
    public NodeSchedulerConfig setMaxSplitsPerNode(int maxSplitsPerNode) {
        this.maxSplitsPerNode = maxSplitsPerNode;
        return this;
    }

    public boolean getOptimizedLocalScheduling() {
        return this.optimizedLocalScheduling;
    }

    @Config(value="node-scheduler.optimized-local-scheduling")
    public NodeSchedulerConfig setOptimizedLocalScheduling(boolean optimizedLocalScheduling) {
        this.optimizedLocalScheduling = optimizedLocalScheduling;
        return this;
    }

    public static enum NodeSchedulerPolicy {
        UNIFORM,
        TOPOLOGY;

    }
}

