/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.prestosql.metadata.BoundSignature;
import io.prestosql.metadata.FunctionId;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeId;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.type.TypeDeserializer;
import io.prestosql.type.TypeSignatureDeserializer;
import io.prestosql.type.TypeSignatureKeyDeserializer;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Provider;

public class ResolvedFunction {
    private static final JsonCodec<ResolvedFunction> SERIALIZE_JSON_CODEC = new JsonCodecFactory().jsonCodec(ResolvedFunction.class);
    private static final String PREFIX = "@";
    private final BoundSignature signature;
    private final FunctionId functionId;
    private final Map<TypeSignature, Type> typeDependencies;
    private final Set<ResolvedFunction> functionDependencies;

    @JsonCreator
    public ResolvedFunction(@JsonProperty(value="signature") BoundSignature signature, @JsonProperty(value="id") FunctionId functionId, @JsonProperty(value="typeDependencies") Map<TypeSignature, Type> typeDependencies, @JsonProperty(value="functionDependencies") Set<ResolvedFunction> functionDependencies) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.typeDependencies = ImmutableMap.copyOf(Objects.requireNonNull(typeDependencies, "typeDependencies is null"));
        this.functionDependencies = ImmutableSet.copyOf((Collection)Objects.requireNonNull(functionDependencies, "functionDependencies is null"));
    }

    @JsonProperty
    public BoundSignature getSignature() {
        return this.signature;
    }

    @JsonProperty(value="id")
    public FunctionId getFunctionId() {
        return this.functionId;
    }

    @JsonProperty
    public Map<TypeSignature, Type> getTypeDependencies() {
        return this.typeDependencies;
    }

    @JsonProperty
    public Set<ResolvedFunction> getFunctionDependencies() {
        return this.functionDependencies;
    }

    public static boolean isResolved(QualifiedName name) {
        return name.getSuffix().startsWith(PREFIX);
    }

    public QualifiedName toQualifiedName() {
        byte[] json = SERIALIZE_JSON_CODEC.toJsonBytes((Object)this);
        ZstdCompressor compressor = new ZstdCompressor();
        byte[] compressed = new byte[Math.toIntExact(compressor.maxCompressedLength(json.length))];
        int outputSize = compressor.compress(json, 0, json.length, compressed, 0, compressed.length);
        String base32 = BaseEncoding.base32Hex().encode(compressed, 0, outputSize);
        return QualifiedName.of((String)(PREFIX + this.signature.getName() + PREFIX + base32));
    }

    public static String extractFunctionName(QualifiedName qualifiedName) {
        String data = qualifiedName.getSuffix();
        if (!data.startsWith(PREFIX)) {
            return data;
        }
        List parts = Splitter.on((String)PREFIX).splitToList(data.subSequence(1, data.length()));
        Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (String)"Expected encoded resolved function to contain two parts: %s", (Object)qualifiedName);
        return (String)parts.get(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedFunction that = (ResolvedFunction)o;
        return Objects.equals(this.signature, that.signature) && Objects.equals(this.functionId, that.functionId) && Objects.equals(this.typeDependencies, that.typeDependencies) && Objects.equals(this.functionDependencies, that.functionDependencies);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.functionId, this.typeDependencies, this.functionDependencies);
    }

    public String toString() {
        return this.signature.toString();
    }

    public static class ResolvedFunctionDecoder {
        private final JsonCodec<ResolvedFunction> jsonCodec;

        public ResolvedFunctionDecoder(Function<TypeId, Type> typeLoader) {
            ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
            objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TypeDeserializer(typeLoader)), TypeSignature.class, (Object)((Object)new TypeSignatureDeserializer())));
            objectMapperProvider.setKeyDeserializers((Map)ImmutableMap.of(TypeSignature.class, (Object)((Object)new TypeSignatureKeyDeserializer())));
            this.jsonCodec = new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(ResolvedFunction.class);
        }

        public Optional<ResolvedFunction> fromQualifiedName(QualifiedName qualifiedName) {
            String data = qualifiedName.getSuffix();
            if (!data.startsWith(ResolvedFunction.PREFIX)) {
                return Optional.empty();
            }
            List parts = Splitter.on((String)ResolvedFunction.PREFIX).splitToList(data.subSequence(1, data.length()));
            Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (String)"Expected encoded resolved function to contain two parts: %s", (Object)qualifiedName);
            String name = (String)parts.get(0);
            String base32 = (String)parts.get(1);
            base32 = base32.toUpperCase(Locale.ENGLISH);
            byte[] compressed = BaseEncoding.base32Hex().decode((CharSequence)base32);
            byte[] json = new byte[Math.toIntExact(ZstdDecompressor.getDecompressedSize((byte[])compressed, (int)0, (int)compressed.length))];
            new ZstdDecompressor().decompress(compressed, 0, compressed.length, json, 0, json.length);
            ResolvedFunction resolvedFunction = (ResolvedFunction)this.jsonCodec.fromJson(json);
            Preconditions.checkArgument((boolean)resolvedFunction.getSignature().getName().equalsIgnoreCase(name), (String)"Expected decoded function to have name %s, but name is %s", (Object)resolvedFunction.getSignature().getName(), (Object)name);
            return Optional.of(resolvedFunction);
        }
    }
}

