/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import io.prestosql.operator.aggregation.Accumulator;
import io.prestosql.operator.aggregation.AccumulatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.plan.AggregationNode;

class Aggregator {
    private final Accumulator aggregation;
    private final AggregationNode.Step step;
    private final int intermediateChannel;

    Aggregator(AccumulatorFactory accumulatorFactory, AggregationNode.Step step) {
        if (step.isInputRaw()) {
            this.intermediateChannel = -1;
            this.aggregation = accumulatorFactory.createAccumulator();
        } else {
            Preconditions.checkArgument((accumulatorFactory.getInputChannels().size() == 1 ? 1 : 0) != 0, (Object)"expected 1 input channel for intermediate aggregation");
            this.intermediateChannel = accumulatorFactory.getInputChannels().get(0);
            this.aggregation = accumulatorFactory.createIntermediateAccumulator();
        }
        this.step = step;
    }

    public Type getType() {
        if (this.step.isOutputPartial()) {
            return this.aggregation.getIntermediateType();
        }
        return this.aggregation.getFinalType();
    }

    public void processPage(Page page) {
        if (this.step.isInputRaw()) {
            this.aggregation.addInput(page);
        } else {
            this.aggregation.addIntermediate(page.getBlock(this.intermediateChannel));
        }
    }

    public void evaluate(BlockBuilder blockBuilder) {
        if (this.step.isOutputPartial()) {
            this.aggregation.evaluateIntermediate(blockBuilder);
        } else {
            this.aggregation.evaluateFinal(blockBuilder);
        }
    }

    public long getEstimatedSize() {
        return this.aggregation.getEstimatedSize();
    }
}

