/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.PagesIndexComparator;
import io.prestosql.operator.SyntheticAddress;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.SortOrder;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SimplePagesIndexComparator
implements PagesIndexComparator {
    private final List<Integer> sortChannels;
    private final List<MethodHandle> orderingOperators;

    public SimplePagesIndexComparator(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders, TypeOperators typeOperators) {
        this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
        Objects.requireNonNull(sortTypes, "sortTypes is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        ImmutableList.Builder orderingOperators = ImmutableList.builder();
        for (int index = 0; index < sortTypes.size(); ++index) {
            Type type = sortTypes.get(index);
            SortOrder sortOrder = sortOrders.get(index);
            orderingOperators.add((Object)typeOperators.getOrderingOperator(type, sortOrder, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION})));
        }
        this.orderingOperators = orderingOperators.build();
    }

    @Override
    public int compareTo(PagesIndex pagesIndex, int leftPosition, int rightPosition) {
        long leftPageAddress = pagesIndex.getValueAddresses().getLong(leftPosition);
        int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
        int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
        long rightPageAddress = pagesIndex.getValueAddresses().getLong(rightPosition);
        int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
        int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
        try {
            for (int i = 0; i < this.sortChannels.size(); ++i) {
                int sortChannel = this.sortChannels.get(i);
                Block leftBlock = (Block)pagesIndex.getChannel(sortChannel).get(leftBlockIndex);
                Block rightBlock = (Block)pagesIndex.getChannel(sortChannel).get(rightBlockIndex);
                MethodHandle orderingOperator = this.orderingOperators.get(i);
                int compare = orderingOperator.invokeExact(leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
        }
    }
}

