/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.OperatorInfo;
import io.prestosql.operator.PageBuffer;
import io.prestosql.operator.PageWithPositionComparator;
import io.prestosql.operator.PagesHashStrategy;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.PagesIndexComparator;
import io.prestosql.operator.WindowFunctionDefinition;
import io.prestosql.operator.WindowInfo;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.window.FrameInfo;
import io.prestosql.operator.window.FramedWindowFunction;
import io.prestosql.operator.window.WindowPartition;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.connector.SortOrder;
import io.prestosql.spi.type.Type;
import io.prestosql.spiller.Spiller;
import io.prestosql.spiller.SpillerFactory;
import io.prestosql.sql.gen.OrderingCompiler;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.WindowFrame;
import io.prestosql.util.MergeSortedPages;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.stream.Stream;

public class WindowOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> outputTypes;
    private final int[] outputChannels;
    private final List<FramedWindowFunction> windowFunctions;
    private final WindowInfo.DriverWindowInfoBuilder windowInfo;
    private final AtomicReference<Optional<WindowInfo.DriverWindowInfo>> driverWindowInfo = new AtomicReference(Optional.empty());
    private final Optional<SpillablePagesToPagesIndexes> spillablePagesToPagesIndexes;
    private final WorkProcessor<Page> outputPages;
    private final PageBuffer pageBuffer = new PageBuffer();

    public WindowOperator(OperatorContext operatorContext, List<Type> sourceTypes, List<Integer> outputChannels, List<WindowFunctionDefinition> windowFunctionDefinitions, List<Integer> partitionChannels, List<Integer> preGroupedChannels, List<Integer> sortChannels, List<SortOrder> sortOrder, int preSortedChannelPrefix, int expectedPositions, PagesIndex.Factory pagesIndexFactory, boolean spillEnabled, SpillerFactory spillerFactory, OrderingCompiler orderingCompiler) {
        ImmutableList ordering;
        ImmutableList orderChannels;
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(outputChannels, "outputChannels is null");
        Objects.requireNonNull(windowFunctionDefinitions, "windowFunctionDefinitions is null");
        Objects.requireNonNull(partitionChannels, "partitionChannels is null");
        Objects.requireNonNull(preGroupedChannels, "preGroupedChannels is null");
        Preconditions.checkArgument((boolean)partitionChannels.containsAll(preGroupedChannels), (Object)"preGroupedChannels must be a subset of partitionChannels");
        Objects.requireNonNull(sortChannels, "sortChannels is null");
        Objects.requireNonNull(sortOrder, "sortOrder is null");
        Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        Objects.requireNonNull(spillerFactory, "spillerFactory is null");
        Preconditions.checkArgument((sortChannels.size() == sortOrder.size() ? 1 : 0) != 0, (Object)"Must have same number of sort channels as sort orders");
        Preconditions.checkArgument((preSortedChannelPrefix <= sortChannels.size() ? 1 : 0) != 0, (Object)"Cannot have more pre-sorted channels than specified sorted channels");
        Preconditions.checkArgument((preSortedChannelPrefix == 0 || ImmutableSet.copyOf(preGroupedChannels).equals((Object)ImmutableSet.copyOf(partitionChannels)) ? 1 : 0) != 0, (Object)"preSortedChannelPrefix can only be greater than zero if all partition channels are pre-grouped");
        this.operatorContext = operatorContext;
        this.outputChannels = Ints.toArray(outputChannels);
        this.windowFunctions = (List)windowFunctionDefinitions.stream().map(functionDefinition -> new FramedWindowFunction(functionDefinition.createWindowFunction(), functionDefinition.getFrameInfo())).collect(ImmutableList.toImmutableList());
        this.outputTypes = (List)Stream.concat(outputChannels.stream().map(sourceTypes::get), windowFunctionDefinitions.stream().map(WindowFunctionDefinition::getType)).collect(ImmutableList.toImmutableList());
        List unGroupedPartitionChannels = (List)partitionChannels.stream().filter(channel -> !preGroupedChannels.contains(channel)).collect(ImmutableList.toImmutableList());
        List preSortedChannels = (List)sortChannels.stream().limit(preSortedChannelPrefix).collect(ImmutableList.toImmutableList());
        ImmutableList unGroupedOrderChannels = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)unGroupedPartitionChannels, sortChannels));
        ImmutableList unGroupedOrdering = ImmutableList.copyOf((Iterable)Iterables.concat(Collections.nCopies(unGroupedPartitionChannels.size(), SortOrder.ASC_NULLS_LAST), sortOrder));
        if (preSortedChannelPrefix > 0) {
            orderChannels = ImmutableList.copyOf((Iterable)Iterables.skip(sortChannels, (int)preSortedChannelPrefix));
            ordering = ImmutableList.copyOf((Iterable)Iterables.skip(sortOrder, (int)preSortedChannelPrefix));
        } else {
            orderChannels = unGroupedOrderChannels;
            ordering = unGroupedOrdering;
        }
        PagesIndexWithHashStrategies inMemoryPagesIndexWithHashStrategies = new PagesIndexWithHashStrategies(pagesIndexFactory, sourceTypes, expectedPositions, preGroupedChannels, unGroupedPartitionChannels, preSortedChannels, sortChannels, windowFunctionDefinitions);
        if (spillEnabled) {
            PagesIndexWithHashStrategies mergedPagesIndexWithHashStrategies = new PagesIndexWithHashStrategies(pagesIndexFactory, sourceTypes, expectedPositions, partitionChannels, (List<Integer>)ImmutableList.of(), sortChannels, sortChannels, windowFunctionDefinitions);
            this.spillablePagesToPagesIndexes = Optional.of(new SpillablePagesToPagesIndexes(inMemoryPagesIndexWithHashStrategies, mergedPagesIndexWithHashStrategies, sourceTypes, (List<Integer>)orderChannels, (List<SortOrder>)ordering, spillerFactory, orderingCompiler.compilePageWithPositionComparator(sourceTypes, (List<Integer>)unGroupedOrderChannels, (List<SortOrder>)unGroupedOrdering)));
            this.outputPages = this.pageBuffer.pages().flatTransform(this.spillablePagesToPagesIndexes.get()).flatMap(this::pagesIndexToWindowPartitions).transform(new WindowPartitionsToOutputPages());
        } else {
            this.spillablePagesToPagesIndexes = Optional.empty();
            this.outputPages = this.pageBuffer.pages().transform(new PagesToPagesIndexes(inMemoryPagesIndexWithHashStrategies, (List<Integer>)orderChannels, (List<SortOrder>)ordering)).flatMap(this::pagesIndexToWindowPartitions).transform(new WindowPartitionsToOutputPages());
        }
        this.windowInfo = new WindowInfo.DriverWindowInfoBuilder();
        operatorContext.setInfoSupplier(this::getWindowInfo);
    }

    private OperatorInfo getWindowInfo() {
        return new WindowInfo((List)this.driverWindowInfo.get().map(ImmutableList::of).orElse(ImmutableList.of()));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.pageBuffer.finish();
    }

    @Override
    public boolean isFinished() {
        return this.outputPages.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.outputPages.isBlocked()) {
            return this.outputPages.getBlockedFuture();
        }
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return this.pageBuffer.isEmpty() && !this.pageBuffer.isFinished();
    }

    @Override
    public void addInput(Page page) {
        this.pageBuffer.add(page);
    }

    @Override
    public Page getOutput() {
        if (!this.outputPages.process()) {
            return null;
        }
        if (this.outputPages.isFinished()) {
            return null;
        }
        return this.outputPages.getResult();
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        return this.spillablePagesToPagesIndexes.get().spill();
    }

    @Override
    public void finishMemoryRevoke() {
        this.spillablePagesToPagesIndexes.get().finishRevokeMemory();
    }

    private static Map<FrameBoundKey, PagesIndexComparator> createFrameBoundComparators(PagesIndex pagesIndex, List<WindowFunctionDefinition> windowFunctionDefinitions) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < windowFunctionDefinitions.size(); ++i) {
            PagesIndexComparator comparator;
            FrameInfo frameInfo = windowFunctionDefinitions.get(i).getFrameInfo();
            if (frameInfo.getType() != WindowFrame.Type.RANGE) continue;
            if (frameInfo.getStartType() == FrameBound.Type.PRECEDING || frameInfo.getStartType() == FrameBound.Type.FOLLOWING) {
                comparator = pagesIndex.createChannelComparator(frameInfo.getSortKeyChannelForStartComparison(), frameInfo.getStartChannel());
                builder.put((Object)new FrameBoundKey(i, FrameBoundKey.Type.START), (Object)comparator);
            }
            if (frameInfo.getEndType() != FrameBound.Type.PRECEDING && frameInfo.getEndType() != FrameBound.Type.FOLLOWING) continue;
            comparator = pagesIndex.createChannelComparator(frameInfo.getSortKeyChannelForEndComparison(), frameInfo.getEndChannel());
            builder.put((Object)new FrameBoundKey(i, FrameBoundKey.Type.END), (Object)comparator);
        }
        return builder.build();
    }

    private WorkProcessor<WindowPartition> pagesIndexToWindowPartitions(final PagesIndexWithHashStrategies pagesIndexWithHashStrategies) {
        final PagesIndex pagesIndex = pagesIndexWithHashStrategies.pagesIndex;
        this.windowInfo.addIndex(pagesIndex);
        return WorkProcessor.create(new WorkProcessor.Process<WindowPartition>(){
            int partitionStart;

            @Override
            public WorkProcessor.ProcessState<WindowPartition> process() {
                if (this.partitionStart == pagesIndex.getPositionCount()) {
                    return WorkProcessor.ProcessState.finished();
                }
                int partitionEnd = WindowOperator.findGroupEnd(pagesIndex, pagesIndexWithHashStrategies.unGroupedPartitionHashStrategy, this.partitionStart);
                WindowPartition partition = new WindowPartition(pagesIndex, this.partitionStart, partitionEnd, WindowOperator.this.outputChannels, WindowOperator.this.windowFunctions, pagesIndexWithHashStrategies.peerGroupHashStrategy, pagesIndexWithHashStrategies.frameBoundComparators);
                WindowOperator.this.windowInfo.addPartition(partition);
                this.partitionStart = partitionEnd;
                return WorkProcessor.ProcessState.ofResult(partition);
            }
        });
    }

    private int updatePagesIndex(PagesIndexWithHashStrategies pagesIndexWithHashStrategies, Page page, int startPosition, Optional<Page> currentSpillGroupRowPage) {
        Preconditions.checkArgument((page.getPositionCount() > startPosition ? 1 : 0) != 0);
        Page preGroupedPage = page.getColumns(pagesIndexWithHashStrategies.preGroupedPartitionChannels);
        PagesIndex pagesIndex = pagesIndexWithHashStrategies.pagesIndex;
        PagesHashStrategy preGroupedPartitionHashStrategy = pagesIndexWithHashStrategies.preGroupedPartitionHashStrategy;
        if (currentSpillGroupRowPage.isPresent() && !preGroupedPartitionHashStrategy.rowEqualsRow(0, currentSpillGroupRowPage.get().getColumns(pagesIndexWithHashStrategies.preGroupedPartitionChannels), startPosition, preGroupedPage)) {
            return startPosition;
        }
        if (pagesIndex.getPositionCount() == 0 || pagesIndex.positionEqualsRow(preGroupedPartitionHashStrategy, 0, startPosition, preGroupedPage)) {
            int groupEnd = WindowOperator.findGroupEnd(preGroupedPage, preGroupedPartitionHashStrategy, startPosition);
            pagesIndex.addPage(page.getRegion(startPosition, groupEnd - startPosition));
            if (page.getPositionCount() - groupEnd > 0) {
                return groupEnd;
            }
            return page.getPositionCount();
        }
        return startPosition;
    }

    private void sortPagesIndexIfNecessary(PagesIndexWithHashStrategies pagesIndexWithHashStrategies, List<Integer> orderChannels, List<SortOrder> ordering) {
        if (pagesIndexWithHashStrategies.pagesIndex.getPositionCount() > 1 && !orderChannels.isEmpty()) {
            int startPosition = 0;
            while (startPosition < pagesIndexWithHashStrategies.pagesIndex.getPositionCount()) {
                int endPosition = WindowOperator.findGroupEnd(pagesIndexWithHashStrategies.pagesIndex, pagesIndexWithHashStrategies.preSortedPartitionHashStrategy, startPosition);
                pagesIndexWithHashStrategies.pagesIndex.sort(orderChannels, ordering, startPosition, endPosition);
                startPosition = endPosition;
            }
        }
    }

    private static int findGroupEnd(Page page, PagesHashStrategy pagesHashStrategy, int startPosition) {
        Preconditions.checkArgument((page.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Must have at least one position");
        Preconditions.checkPositionIndex((int)startPosition, (int)page.getPositionCount(), (String)"startPosition out of bounds");
        return WindowOperator.findEndPosition(startPosition, page.getPositionCount(), (firstPosition, secondPosition) -> pagesHashStrategy.rowEqualsRow((int)firstPosition, page, (int)secondPosition, page));
    }

    private static int findGroupEnd(PagesIndex pagesIndex, PagesHashStrategy pagesHashStrategy, int startPosition) {
        Preconditions.checkArgument((pagesIndex.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Must have at least one position");
        Preconditions.checkPositionIndex((int)startPosition, (int)pagesIndex.getPositionCount(), (String)"startPosition out of bounds");
        return WindowOperator.findEndPosition(startPosition, pagesIndex.getPositionCount(), (firstPosition, secondPosition) -> pagesIndex.positionEqualsPosition(pagesHashStrategy, (int)firstPosition, (int)secondPosition));
    }

    @VisibleForTesting
    static int findEndPosition(int startPosition, int endPosition, BiPredicate<Integer, Integer> comparator) {
        Preconditions.checkArgument((startPosition >= 0 ? 1 : 0) != 0, (String)"startPosition must be greater or equal than zero: %s", (int)startPosition);
        Preconditions.checkArgument((startPosition < endPosition ? 1 : 0) != 0, (String)"startPosition (%s) must be less than endPosition (%s)", (int)startPosition, (int)endPosition);
        int left = startPosition;
        int right = endPosition;
        while (left + 1 < right) {
            int middle = left + right >>> 1;
            if (comparator.test(startPosition, middle)) {
                left = middle;
                continue;
            }
            right = middle;
        }
        return right;
    }

    @Override
    public void close() {
        this.driverWindowInfo.set(Optional.of(this.windowInfo.build()));
        this.spillablePagesToPagesIndexes.ifPresent(SpillablePagesToPagesIndexes::closeSpiller);
    }

    private class SpillablePagesToPagesIndexes
    implements WorkProcessor.Transformation<Page, WorkProcessor<PagesIndexWithHashStrategies>> {
        final PagesIndexWithHashStrategies inMemoryPagesIndexWithHashStrategies;
        final PagesIndexWithHashStrategies mergedPagesIndexWithHashStrategies;
        final List<Type> sourceTypes;
        final List<Integer> orderChannels;
        final List<SortOrder> ordering;
        final LocalMemoryContext localRevocableMemoryContext;
        final LocalMemoryContext localUserMemoryContext;
        final SpillerFactory spillerFactory;
        final PageWithPositionComparator pageWithPositionComparator;
        boolean spillingWhenConvertingRevocableMemory;
        boolean resetPagesIndex;
        int pendingInputPosition;
        Optional<Page> currentSpillGroupRowPage;
        Optional<Spiller> spiller;
        Optional<ListenableFuture<?>> spillInProgress = Optional.empty();

        SpillablePagesToPagesIndexes(PagesIndexWithHashStrategies inMemoryPagesIndexWithHashStrategies, PagesIndexWithHashStrategies mergedPagesIndexWithHashStrategies, List<Type> sourceTypes, List<Integer> orderChannels, List<SortOrder> ordering, SpillerFactory spillerFactory, PageWithPositionComparator pageWithPositionComparator) {
            this.inMemoryPagesIndexWithHashStrategies = inMemoryPagesIndexWithHashStrategies;
            this.mergedPagesIndexWithHashStrategies = mergedPagesIndexWithHashStrategies;
            this.sourceTypes = sourceTypes;
            this.orderChannels = orderChannels;
            this.ordering = ordering;
            this.localUserMemoryContext = WindowOperator.this.operatorContext.aggregateUserMemoryContext().newLocalMemoryContext(SpillablePagesToPagesIndexes.class.getSimpleName());
            this.localRevocableMemoryContext = WindowOperator.this.operatorContext.aggregateRevocableMemoryContext().newLocalMemoryContext(SpillablePagesToPagesIndexes.class.getSimpleName());
            this.spillerFactory = spillerFactory;
            this.pageWithPositionComparator = pageWithPositionComparator;
            this.currentSpillGroupRowPage = Optional.empty();
            this.spiller = Optional.empty();
        }

        @Override
        public WorkProcessor.TransformationState<WorkProcessor<PagesIndexWithHashStrategies>> process(Page pendingInput) {
            boolean finishing;
            if (this.spillingWhenConvertingRevocableMemory) {
                this.finishRevokeMemory();
                this.spillingWhenConvertingRevocableMemory = false;
                return this.fullGroupBuffered();
            }
            if (this.resetPagesIndex) {
                this.inMemoryPagesIndexWithHashStrategies.pagesIndex.clear();
                this.currentSpillGroupRowPage = Optional.empty();
                this.closeSpiller();
                this.updateMemoryUsage(false);
                this.resetPagesIndex = false;
            }
            boolean bl = finishing = pendingInput == null;
            if (finishing && this.inMemoryPagesIndexWithHashStrategies.pagesIndex.getPositionCount() == 0 && this.spiller.isEmpty()) {
                this.localRevocableMemoryContext.close();
                this.localUserMemoryContext.close();
                this.closeSpiller();
                return WorkProcessor.TransformationState.finished();
            }
            if (!finishing) {
                this.pendingInputPosition = WindowOperator.this.updatePagesIndex(this.inMemoryPagesIndexWithHashStrategies, pendingInput, this.pendingInputPosition, this.currentSpillGroupRowPage);
            }
            if (finishing || this.pendingInputPosition < pendingInput.getPositionCount()) {
                return this.fullGroupBuffered();
            }
            this.updateMemoryUsage(true);
            this.pendingInputPosition = 0;
            return WorkProcessor.TransformationState.needsMoreData();
        }

        void closeSpiller() {
            this.spiller.ifPresent(Spiller::close);
            this.spiller = Optional.empty();
        }

        WorkProcessor.TransformationState<WorkProcessor<PagesIndexWithHashStrategies>> fullGroupBuffered() {
            if (this.localRevocableMemoryContext.getBytes() > 0L) {
                long currentRevocableBytes = this.localRevocableMemoryContext.getBytes();
                this.localRevocableMemoryContext.setBytes(0L);
                if (!this.localUserMemoryContext.trySetBytes(this.localUserMemoryContext.getBytes() + currentRevocableBytes)) {
                    this.localRevocableMemoryContext.setBytes(currentRevocableBytes);
                    this.spillingWhenConvertingRevocableMemory = true;
                    return WorkProcessor.TransformationState.blocked(this.spill());
                }
            }
            WindowOperator.this.sortPagesIndexIfNecessary(this.inMemoryPagesIndexWithHashStrategies, this.orderChannels, this.ordering);
            this.resetPagesIndex = true;
            return WorkProcessor.TransformationState.ofResult(this.unspill(), false);
        }

        ListenableFuture<?> spill() {
            if (this.spillInProgress.isPresent()) {
                return this.spillInProgress.get();
            }
            if (this.localRevocableMemoryContext.getBytes() == 0L) {
                this.spillInProgress = Optional.of(Futures.immediateFuture(null));
                return this.spillInProgress.get();
            }
            if (this.spiller.isEmpty()) {
                this.spiller = Optional.of(this.spillerFactory.create(this.sourceTypes, WindowOperator.this.operatorContext.getSpillContext(), WindowOperator.this.operatorContext.newAggregateSystemMemoryContext()));
            }
            Verify.verify((this.inMemoryPagesIndexWithHashStrategies.pagesIndex.getPositionCount() > 0 ? 1 : 0) != 0);
            WindowOperator.this.sortPagesIndexIfNecessary(this.inMemoryPagesIndexWithHashStrategies, this.orderChannels, this.ordering);
            PeekingIterator sortedPages = Iterators.peekingIterator(this.inMemoryPagesIndexWithHashStrategies.pagesIndex.getSortedPages());
            Page anyPage = (Page)sortedPages.peek();
            Verify.verify((anyPage.getPositionCount() != 0 ? 1 : 0) != 0, (String)"PagesIndex.getSortedPages returned an empty page", (Object[])new Object[0]);
            this.currentSpillGroupRowPage = Optional.of(anyPage.getSingleValuePage(0));
            this.spillInProgress = Optional.of(this.spiller.get().spill((Iterator<Page>)sortedPages));
            return this.spillInProgress.get();
        }

        void finishRevokeMemory() {
            if (this.spillInProgress.isEmpty()) {
                return;
            }
            MoreFutures.checkSuccess((Future)((Future)this.spillInProgress.get()), (String)"spilling failed");
            this.spillInProgress = Optional.empty();
            if (this.localRevocableMemoryContext.getBytes() == 0L) {
                return;
            }
            this.inMemoryPagesIndexWithHashStrategies.pagesIndex.clear();
            this.updateMemoryUsage(false);
        }

        WorkProcessor<PagesIndexWithHashStrategies> unspill() {
            if (this.spiller.isEmpty()) {
                return WorkProcessor.fromIterable(ImmutableList.of((Object)this.inMemoryPagesIndexWithHashStrategies));
            }
            ImmutableList sortedStreams = ImmutableList.builder().addAll((Iterable)this.spiller.get().getSpills().stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList())).add(WorkProcessor.fromIterator(this.inMemoryPagesIndexWithHashStrategies.pagesIndex.getSortedPages())).build();
            WorkProcessor<Page> mergedPages = MergeSortedPages.mergeSortedPages((List<WorkProcessor<Page>>)sortedStreams, this.pageWithPositionComparator, this.sourceTypes, WindowOperator.this.operatorContext.aggregateUserMemoryContext(), WindowOperator.this.operatorContext.getDriverContext().getYieldSignal());
            return mergedPages.transform(new PagesToPagesIndexes(this.mergedPagesIndexWithHashStrategies, (List<Integer>)ImmutableList.of(), (List<SortOrder>)ImmutableList.of()));
        }

        void updateMemoryUsage(boolean revocablePagesIndex) {
            long pagesIndexBytes = this.inMemoryPagesIndexWithHashStrategies.pagesIndex.getEstimatedSize().toBytes();
            if (revocablePagesIndex) {
                Verify.verify((this.inMemoryPagesIndexWithHashStrategies.pagesIndex.getPositionCount() > 0 ? 1 : 0) != 0);
                this.localUserMemoryContext.setBytes(0L);
                this.localRevocableMemoryContext.setBytes(pagesIndexBytes);
            } else {
                this.localRevocableMemoryContext.setBytes(0L);
                this.localUserMemoryContext.setBytes(pagesIndexBytes);
            }
        }
    }

    private class WindowPartitionsToOutputPages
    implements WorkProcessor.Transformation<WindowPartition, Page> {
        final PageBuilder pageBuilder;

        WindowPartitionsToOutputPages() {
            this.pageBuilder = new PageBuilder(WindowOperator.this.outputTypes);
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(WindowPartition partition) {
            boolean finishing;
            boolean bl = finishing = partition == null;
            if (finishing) {
                if (this.pageBuilder.isEmpty()) {
                    return WorkProcessor.TransformationState.finished();
                }
                Page page = this.pageBuilder.build();
                this.pageBuilder.reset();
                return WorkProcessor.TransformationState.ofResult(page, false);
            }
            while (!this.pageBuilder.isFull() && partition.hasNext()) {
                partition.processNextRow(this.pageBuilder);
            }
            if (!this.pageBuilder.isFull()) {
                return WorkProcessor.TransformationState.needsMoreData();
            }
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return WorkProcessor.TransformationState.ofResult(page, !partition.hasNext());
        }
    }

    private class PagesToPagesIndexes
    implements WorkProcessor.Transformation<Page, PagesIndexWithHashStrategies> {
        final PagesIndexWithHashStrategies pagesIndexWithHashStrategies;
        final List<Integer> orderChannels;
        final List<SortOrder> ordering;
        final LocalMemoryContext memoryContext;
        boolean resetPagesIndex;
        int pendingInputPosition;

        PagesToPagesIndexes(PagesIndexWithHashStrategies pagesIndexWithHashStrategies, List<Integer> orderChannels, List<SortOrder> ordering) {
            this.pagesIndexWithHashStrategies = pagesIndexWithHashStrategies;
            this.orderChannels = orderChannels;
            this.ordering = ordering;
            this.memoryContext = WindowOperator.this.operatorContext.aggregateUserMemoryContext().newLocalMemoryContext(PagesToPagesIndexes.class.getSimpleName());
        }

        @Override
        public WorkProcessor.TransformationState<PagesIndexWithHashStrategies> process(Page pendingInput) {
            boolean finishing;
            if (this.resetPagesIndex) {
                this.pagesIndexWithHashStrategies.pagesIndex.clear();
                this.updateMemoryUsage();
                this.resetPagesIndex = false;
            }
            boolean bl = finishing = pendingInput == null;
            if (finishing && this.pagesIndexWithHashStrategies.pagesIndex.getPositionCount() == 0) {
                this.memoryContext.close();
                return WorkProcessor.TransformationState.finished();
            }
            if (!finishing) {
                this.pendingInputPosition = WindowOperator.this.updatePagesIndex(this.pagesIndexWithHashStrategies, pendingInput, this.pendingInputPosition, Optional.empty());
                this.updateMemoryUsage();
            }
            if (finishing || this.pendingInputPosition < pendingInput.getPositionCount()) {
                WindowOperator.this.sortPagesIndexIfNecessary(this.pagesIndexWithHashStrategies, this.orderChannels, this.ordering);
                this.resetPagesIndex = true;
                return WorkProcessor.TransformationState.ofResult(this.pagesIndexWithHashStrategies, false);
            }
            this.pendingInputPosition = 0;
            return WorkProcessor.TransformationState.needsMoreData();
        }

        void updateMemoryUsage() {
            this.memoryContext.setBytes(this.pagesIndexWithHashStrategies.pagesIndex.getEstimatedSize().toBytes());
        }
    }

    public static class FrameBoundKey {
        private final int functionIndex;
        private final Type type;

        public FrameBoundKey(int functionIndex, Type type) {
            this.functionIndex = functionIndex;
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FrameBoundKey that = (FrameBoundKey)o;
            return this.functionIndex == that.functionIndex && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.functionIndex, this.type});
        }

        public static enum Type {
            START,
            END;

        }
    }

    private static class PagesIndexWithHashStrategies {
        final PagesIndex pagesIndex;
        final PagesHashStrategy preGroupedPartitionHashStrategy;
        final PagesHashStrategy unGroupedPartitionHashStrategy;
        final PagesHashStrategy preSortedPartitionHashStrategy;
        final PagesHashStrategy peerGroupHashStrategy;
        final int[] preGroupedPartitionChannels;
        final Map<FrameBoundKey, PagesIndexComparator> frameBoundComparators;

        PagesIndexWithHashStrategies(PagesIndex.Factory pagesIndexFactory, List<Type> sourceTypes, int expectedPositions, List<Integer> preGroupedPartitionChannels, List<Integer> unGroupedPartitionChannels, List<Integer> preSortedChannels, List<Integer> sortChannels, List<WindowFunctionDefinition> windowFunctionDefinitions) {
            this.pagesIndex = pagesIndexFactory.newPagesIndex(sourceTypes, expectedPositions);
            this.preGroupedPartitionHashStrategy = this.pagesIndex.createPagesHashStrategy(preGroupedPartitionChannels, OptionalInt.empty());
            this.unGroupedPartitionHashStrategy = this.pagesIndex.createPagesHashStrategy(unGroupedPartitionChannels, OptionalInt.empty());
            this.preSortedPartitionHashStrategy = this.pagesIndex.createPagesHashStrategy(preSortedChannels, OptionalInt.empty());
            this.peerGroupHashStrategy = this.pagesIndex.createPagesHashStrategy(sortChannels, OptionalInt.empty());
            this.preGroupedPartitionChannels = Ints.toArray(preGroupedPartitionChannels);
            this.frameBoundComparators = WindowOperator.createFrameBoundComparators(this.pagesIndex, windowFunctionDefinitions);
        }
    }

    public static class WindowOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final List<WindowFunctionDefinition> windowFunctionDefinitions;
        private final List<Integer> partitionChannels;
        private final List<Integer> preGroupedChannels;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrder;
        private final int preSortedChannelPrefix;
        private final int expectedPositions;
        private boolean closed;
        private final PagesIndex.Factory pagesIndexFactory;
        private final boolean spillEnabled;
        private final SpillerFactory spillerFactory;
        private final OrderingCompiler orderingCompiler;

        public WindowOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<WindowFunctionDefinition> windowFunctionDefinitions, List<Integer> partitionChannels, List<Integer> preGroupedChannels, List<Integer> sortChannels, List<SortOrder> sortOrder, int preSortedChannelPrefix, int expectedPositions, PagesIndex.Factory pagesIndexFactory, boolean spillEnabled, SpillerFactory spillerFactory, OrderingCompiler orderingCompiler) {
            Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            Objects.requireNonNull(planNodeId, "planNodeId is null");
            Objects.requireNonNull(outputChannels, "outputChannels is null");
            Objects.requireNonNull(windowFunctionDefinitions, "windowFunctionDefinitions is null");
            Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            Objects.requireNonNull(preGroupedChannels, "preGroupedChannels is null");
            Preconditions.checkArgument((boolean)partitionChannels.containsAll(preGroupedChannels), (Object)"preGroupedChannels must be a subset of partitionChannels");
            Objects.requireNonNull(sortChannels, "sortChannels is null");
            Objects.requireNonNull(sortOrder, "sortOrder is null");
            Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
            Objects.requireNonNull(spillerFactory, "spillerFactory is null");
            Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
            Preconditions.checkArgument((sortChannels.size() == sortOrder.size() ? 1 : 0) != 0, (Object)"Must have same number of sort channels as sort orders");
            Preconditions.checkArgument((preSortedChannelPrefix <= sortChannels.size() ? 1 : 0) != 0, (Object)"Cannot have more pre-sorted channels than specified sorted channels");
            Preconditions.checkArgument((preSortedChannelPrefix == 0 || ImmutableSet.copyOf(preGroupedChannels).equals((Object)ImmutableSet.copyOf(partitionChannels)) ? 1 : 0) != 0, (Object)"preSortedChannelPrefix can only be greater than zero if all partition channels are pre-grouped");
            this.pagesIndexFactory = pagesIndexFactory;
            this.operatorId = operatorId;
            this.planNodeId = planNodeId;
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.outputChannels = ImmutableList.copyOf(outputChannels);
            this.windowFunctionDefinitions = ImmutableList.copyOf(windowFunctionDefinitions);
            this.partitionChannels = ImmutableList.copyOf(partitionChannels);
            this.preGroupedChannels = ImmutableList.copyOf(preGroupedChannels);
            this.sortChannels = ImmutableList.copyOf(sortChannels);
            this.sortOrder = ImmutableList.copyOf(sortOrder);
            this.preSortedChannelPrefix = preSortedChannelPrefix;
            this.expectedPositions = expectedPositions;
            this.spillEnabled = spillEnabled;
            this.spillerFactory = spillerFactory;
            this.orderingCompiler = orderingCompiler;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, WindowOperator.class.getSimpleName());
            return new WindowOperator(operatorContext, this.sourceTypes, this.outputChannels, this.windowFunctionDefinitions, this.partitionChannels, this.preGroupedChannels, this.sortChannels, this.sortOrder, this.preSortedChannelPrefix, this.expectedPositions, this.pagesIndexFactory, this.spillEnabled, this.spillerFactory, this.orderingCompiler);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new WindowOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.outputChannels, this.windowFunctionDefinitions, this.partitionChannels, this.preGroupedChannels, this.sortChannels, this.sortOrder, this.preSortedChannelPrefix, this.expectedPositions, this.pagesIndexFactory, this.spillEnabled, this.spillerFactory, this.orderingCompiler);
        }
    }
}

