/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.airlift.stats.TDigest;
import io.prestosql.operator.aggregation.ApproximateDoublePercentileArrayAggregations;
import io.prestosql.operator.aggregation.ApproximateLongPercentileAggregations;
import io.prestosql.operator.aggregation.state.TDigestAndPercentileArrayState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.BigintType;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateLongPercentileArrayAggregations {
    private ApproximateLongPercentileArrayAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState TDigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateDoublePercentileArrayAggregations.input(state, ApproximateLongPercentileAggregations.toDoubleExact(value), percentilesArrayBlock);
    }

    @InputFunction
    public static void weightedInput(@AggregationState TDigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="double") double weight, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateDoublePercentileArrayAggregations.weightedInput(state, ApproximateLongPercentileAggregations.toDoubleExact(value), weight, percentilesArrayBlock);
    }

    @CombineFunction
    public static void combine(@AggregationState TDigestAndPercentileArrayState state, TDigestAndPercentileArrayState otherState) {
        ApproximateDoublePercentileArrayAggregations.combine(state, otherState);
    }

    @OutputFunction(value="array(bigint)")
    public static void output(@AggregationState TDigestAndPercentileArrayState state, BlockBuilder out) {
        TDigest digest = state.getDigest();
        List<Double> percentiles = state.getPercentiles();
        if (percentiles == null || digest == null) {
            out.appendNull();
            return;
        }
        BlockBuilder blockBuilder = out.beginBlockEntry();
        List<Double> valuesAtPercentiles = ApproximateDoublePercentileArrayAggregations.valuesAtPercentiles(digest, percentiles);
        for (double value : valuesAtPercentiles) {
            BigintType.BIGINT.writeLong(blockBuilder, Math.round(value));
        }
        out.closeEntry();
    }
}

