/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import io.airlift.slice.SizeOf;
import io.airlift.stats.TDigest;
import io.prestosql.array.ObjectBigArray;
import io.prestosql.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.prestosql.operator.aggregation.state.TDigestAndPercentileArrayState;
import io.prestosql.spi.function.AccumulatorStateFactory;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class TDigestAndPercentileArrayStateFactory
implements AccumulatorStateFactory<TDigestAndPercentileArrayState> {
    public TDigestAndPercentileArrayState createSingleState() {
        return new SingleTDigestAndPercentileArrayState();
    }

    public Class<? extends TDigestAndPercentileArrayState> getSingleStateClass() {
        return SingleTDigestAndPercentileArrayState.class;
    }

    public TDigestAndPercentileArrayState createGroupedState() {
        return new GroupedTDigestAndPercentileArrayState();
    }

    public Class<? extends TDigestAndPercentileArrayState> getGroupedStateClass() {
        return GroupedTDigestAndPercentileArrayState.class;
    }

    public static class SingleTDigestAndPercentileArrayState
    implements TDigestAndPercentileArrayState {
        public static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleTDigestAndPercentileArrayState.class).instanceSize();
        private TDigest digest;
        private List<Double> percentiles;

        @Override
        public TDigest getDigest() {
            return this.digest;
        }

        @Override
        public void setDigest(TDigest digest) {
            this.digest = Objects.requireNonNull(digest, "digest is null");
        }

        @Override
        public List<Double> getPercentiles() {
            return this.percentiles;
        }

        @Override
        public void setPercentiles(List<Double> percentiles) {
            this.percentiles = Objects.requireNonNull(percentiles, "percentiles is null");
        }

        @Override
        public void addMemoryUsage(int value) {
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.digest != null) {
                estimatedSize += (long)this.digest.estimatedInMemorySizeInBytes();
            }
            if (this.percentiles != null) {
                estimatedSize += SizeOf.sizeOfDoubleArray((int)this.percentiles.size());
            }
            return estimatedSize;
        }
    }

    public static class GroupedTDigestAndPercentileArrayState
    extends AbstractGroupedAccumulatorState
    implements TDigestAndPercentileArrayState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedTDigestAndPercentileArrayState.class).instanceSize();
        private final ObjectBigArray<TDigest> digests = new ObjectBigArray();
        private final ObjectBigArray<List<Double>> percentilesArray = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.digests.ensureCapacity(size);
            this.percentilesArray.ensureCapacity(size);
        }

        @Override
        public TDigest getDigest() {
            return (TDigest)this.digests.get(this.getGroupId());
        }

        @Override
        public void setDigest(TDigest digest) {
            this.digests.set(this.getGroupId(), (Object)Objects.requireNonNull(digest, "digest is null"));
        }

        @Override
        public List<Double> getPercentiles() {
            return (List)this.percentilesArray.get(this.getGroupId());
        }

        @Override
        public void setPercentiles(List<Double> percentiles) {
            this.percentilesArray.set(this.getGroupId(), Objects.requireNonNull(percentiles, "percentiles is null"));
        }

        @Override
        public void addMemoryUsage(int value) {
            this.size += (long)value;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.digests.sizeOf() + this.percentilesArray.sizeOf();
        }
    }
}

