/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.annotations;

import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.operator.annotations.ImplementationDependency;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import java.util.Objects;
import java.util.Set;

public final class TypeImplementationDependency
implements ImplementationDependency {
    private final TypeSignature signature;

    public TypeImplementationDependency(String signature) {
        this.signature = TypeSignatureTranslator.parseTypeSignature(Objects.requireNonNull(signature, "signature is null"), (Set<String>)ImmutableSet.of());
    }

    @Override
    public void declareDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder) {
        builder.addType(this.signature);
    }

    @Override
    public Object resolve(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        return functionDependencies.getType(SignatureBinder.applyBoundVariables(this.signature, functionBinding));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeImplementationDependency that = (TypeImplementationDependency)o;
        return Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.signature);
    }
}

