/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ChoicesScalarFunctionImplementation;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.SqlTypeBytecodeExpression;
import io.prestosql.util.CompilerUtils;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public final class ArrayConstructor
extends SqlScalarFunction {
    public static final ArrayConstructor ARRAY_CONSTRUCTOR = new ArrayConstructor();

    public ArrayConstructor() {
        super(new FunctionMetadata(new Signature("array_constructor", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("E")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("E", new TypeSignatureParameter[0]), (Object)new TypeSignature("E", new TypeSignatureParameter[0])), true), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(true), (Object)new FunctionArgumentDefinition(true)), true, true, "", FunctionKind.SCALAR));
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        MethodHandle methodHandle;
        ImmutableList.Builder builder = ImmutableList.builder();
        Type type = functionBinding.getTypeVariable("E");
        for (int i = 0; i < functionBinding.getArity(); ++i) {
            if (type.getJavaType().isPrimitive()) {
                builder.add((Object)Primitives.wrap((Class)type.getJavaType()));
                continue;
            }
            builder.add((Object)type.getJavaType());
        }
        ImmutableList stackTypes = builder.build();
        Class<?> clazz = ArrayConstructor.generateArrayConstructor(stackTypes, type);
        try {
            Method method = clazz.getMethod("arrayConstructor", (Class[])stackTypes.toArray((Object[])new Class[stackTypes.size()]));
            methodHandle = MethodHandles.lookup().unreflect(method);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(stackTypes.size(), InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE), methodHandle);
    }

    private static Class<?> generateArrayConstructor(List<Class<?>> stackTypes, Type elementType) {
        Failures.checkCondition(stackTypes.size() <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for array constructor", new Object[0]);
        List stackTypeNames = (List)stackTypes.stream().map(Class::getSimpleName).collect(ImmutableList.toImmutableList());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(Joiner.on((String)"").join((Iterable)stackTypeNames) + "ArrayConstructor"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int i = 0; i < stackTypes.size(); ++i) {
            Class<?> stackType = stackTypes.get(i);
            parameters.add((Object)Parameter.arg((String)("arg" + i), stackType));
        }
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "arrayConstructor", ParameterizedType.type(Block.class), (Iterable)parameters.build());
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable blockBuilderVariable = scope.declareVariable(BlockBuilder.class, "blockBuilder");
        CallSiteBinder binder = new CallSiteBinder();
        BytecodeExpression createBlockBuilder = blockBuilderVariable.set(SqlTypeBytecodeExpression.constantType(binder, elementType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), BytecodeExpressions.constantInt((int)stackTypes.size())}));
        body.append((BytecodeNode)createBlockBuilder);
        for (int i = 0; i < stackTypes.size(); ++i) {
            Variable argument = scope.getVariable("arg" + i);
            IfStatement ifStatement = new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)argument, (BytecodeExpression)BytecodeExpressions.constantNull(stackTypes.get(i)))).ifTrue((BytecodeNode)blockBuilderVariable.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, elementType).writeValue((BytecodeExpression)blockBuilderVariable, argument.cast(elementType.getJavaType())));
            body.append((BytecodeNode)ifStatement);
        }
        body.append((BytecodeNode)blockBuilderVariable.invoke("build", Block.class, new BytecodeExpression[0]).ret());
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), (ClassLoader)new DynamicClassLoader(ArrayConstructor.class.getClassLoader()));
    }
}

