/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.operator.aggregation.TypedSet;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.type.BlockTypeOperators;

@ScalarFunction(value="array_except")
@Description(value="Returns an array of elements that are in the first array but not the second, without duplicates.")
public final class ArrayExceptFunction {
    private ArrayExceptFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block except(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) BlockTypeOperators.BlockPositionEqual elementEqual, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode elementHashCode, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int i;
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (leftPositionCount == 0) {
            return leftArray;
        }
        TypedSet typedSet = TypedSet.createEqualityTypedSet(type, elementEqual, elementHashCode, leftPositionCount + rightPositionCount, "array_except");
        BlockBuilder distinctElementBlockBuilder = type.createBlockBuilder(null, leftPositionCount);
        for (i = 0; i < rightPositionCount; ++i) {
            typedSet.add(rightArray, i);
        }
        for (i = 0; i < leftPositionCount; ++i) {
            if (typedSet.contains(leftArray, i)) continue;
            typedSet.add(leftArray, i);
            type.appendTo(leftArray, i, distinctElementBlockBuilder);
        }
        return distinctElementBlockBuilder.build();
    }
}

