/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ChoicesScalarFunctionImplementation;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;

public final class ConcatFunction
extends SqlScalarFunction {
    public static final ConcatFunction VARCHAR_CONCAT = new ConcatFunction(VarcharType.VARCHAR.getTypeSignature(), "Concatenates given strings");
    public static final ConcatFunction VARBINARY_CONCAT = new ConcatFunction(VarbinaryType.VARBINARY.getTypeSignature(), "concatenates given varbinary values");
    private static final int MAX_INPUT_VALUES = 254;
    private static final int MAX_OUTPUT_LENGTH = 0x100000;

    private ConcatFunction(TypeSignature type, String description) {
        super(new FunctionMetadata(new Signature("concat", (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), type, (List<TypeSignature>)ImmutableList.of((Object)type), true), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), false, true, description, FunctionKind.SCALAR));
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        int arity = functionBinding.getArity();
        if (arity < 2) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more concatenation arguments");
        }
        if (arity > 254) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for string concatenation");
        }
        MethodHandle arrayMethodHandle = Reflection.methodHandle(ConcatFunction.class, "concat", Slice[].class);
        MethodHandle customMethodHandle = arrayMethodHandle.asCollector(Slice[].class, arity);
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(arity, InvocationConvention.InvocationArgumentConvention.NEVER_NULL), customMethodHandle);
    }

    public static Slice concat(Slice[] values) {
        int length = 0;
        for (Slice value : values) {
            if ((length = Math.addExact(length, value.length())) <= 0x100000) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Concatenated string is too large");
        }
        Slice result = Slices.allocate((int)length);
        int position = 0;
        for (Slice value : values) {
            result.setBytes(position, value);
            position += value.length();
        }
        return result;
    }
}

