/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ArrayConcatUtils;
import io.prestosql.operator.scalar.ChoicesScalarFunctionImplementation;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ElementToArrayConcatFunction
extends SqlScalarFunction {
    public static final ElementToArrayConcatFunction ELEMENT_TO_ARRAY_CONCAT_FUNCTION = new ElementToArrayConcatFunction();
    private static final String FUNCTION_NAME = "concat";
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(ArrayConcatUtils.class, "prependElement", Type.class, Boolean.TYPE, Block.class);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(ArrayConcatUtils.class, "prependElement", Type.class, Long.TYPE, Block.class);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(ArrayConcatUtils.class, "prependElement", Type.class, Double.TYPE, Block.class);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(ArrayConcatUtils.class, "prependElement", Type.class, Slice.class, Block.class);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(ArrayConcatUtils.class, "prependElement", Type.class, Object.class, Block.class);

    public ElementToArrayConcatFunction() {
        super(new FunctionMetadata(new Signature(FUNCTION_NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("E")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("E", new TypeSignatureParameter[0]), (Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))), false), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), false, true, "Concatenates an element to an array", FunctionKind.SCALAR));
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Type type = functionBinding.getTypeVariable("E");
        MethodHandle methodHandle = type.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (type.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (type.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (type.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT)));
        methodHandle = methodHandle.bindTo(type);
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }
}

