/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ChoicesScalarFunctionImplementation;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.JsonType;
import io.prestosql.util.Failures;
import io.prestosql.util.JsonCastException;
import io.prestosql.util.JsonUtil;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class JsonToMapCast
extends SqlOperator {
    public static final JsonToMapCast JSON_TO_MAP = new JsonToMapCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonToMapCast.class, "toMap", MapType.class, JsonUtil.BlockBuilderAppender.class, ConnectorSession.class, Slice.class);

    private JsonToMapCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.castableFromTypeParameter("K", VarcharType.VARCHAR.getTypeSignature()), (Object)Signature.castableFromTypeParameter("V", JsonType.JSON.getTypeSignature())), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)JsonType.JSON.getTypeSignature()), true);
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Preconditions.checkArgument((functionBinding.getArity() == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        MapType mapType = (MapType)functionBinding.getBoundSignature().getReturnType();
        Failures.checkCondition(JsonUtil.canCastFromJson((Type)mapType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast JSON to %s", mapType);
        JsonUtil.BlockBuilderAppender mapAppender = JsonUtil.BlockBuilderAppender.createBlockBuilderAppender((Type)mapType);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(mapType).bindTo(mapAppender);
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UsedByGeneratedCode
    public static Block toMap(MapType mapType, JsonUtil.BlockBuilderAppender mapAppender, ConnectorSession connectorSession, Slice json) {
        try (JsonParser jsonParser = JsonUtil.createJsonParser(JsonUtil.JSON_FACTORY, json);){
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                Block block2 = null;
                return block2;
            }
            BlockBuilder blockBuilder = mapType.createBlockBuilder(null, 1);
            mapAppender.append(jsonParser, blockBuilder);
            if (jsonParser.nextToken() != null) {
                throw new JsonCastException(String.format("Unexpected trailing token: %s", jsonParser.getText()));
            }
            Block block = mapType.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
            return block;
        }
        catch (PrestoException | JsonCastException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s. %s\n%s", mapType, e.getMessage(), JsonUtil.truncateIfNecessaryForErrorMessage(json)), e);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s.\n%s", mapType, JsonUtil.truncateIfNecessaryForErrorMessage(json)), (Throwable)e);
        }
    }
}

