/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ChoicesScalarFunctionImplementation;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.SingleMapBlock;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class MapElementAtFunction
extends SqlScalarFunction {
    public static final MapElementAtFunction MAP_ELEMENT_AT = new MapElementAtFunction();
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(MapElementAtFunction.class, "elementAt", Type.class, Block.class, Boolean.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(MapElementAtFunction.class, "elementAt", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(MapElementAtFunction.class, "elementAt", Type.class, Block.class, Double.TYPE);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(MapElementAtFunction.class, "elementAt", Type.class, Block.class, Object.class);

    protected MapElementAtFunction() {
        super(new FunctionMetadata(new Signature("element_at", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("V", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0])), (Object)new TypeSignature("K", new TypeSignatureParameter[0])), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), false, true, "Get value for the given key, or null if it does not exist", FunctionKind.SCALAR));
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addOperatorSignature(OperatorType.EQUAL, (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("K", new TypeSignatureParameter[0]), (Object)new TypeSignature("K", new TypeSignatureParameter[0]))).build();
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        Type keyType = functionBinding.getTypeVariable("K");
        Type valueType = functionBinding.getTypeVariable("V");
        MethodHandle methodHandle = keyType.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (keyType.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (keyType.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : METHOD_HANDLE_OBJECT));
        methodHandle = methodHandle.bindTo(valueType);
        methodHandle = methodHandle.asType(methodHandle.type().changeReturnType(Primitives.wrap((Class)valueType.getJavaType())));
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static Object elementAt(Type valueType, Block map, boolean key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            return null;
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object elementAt(Type valueType, Block map, long key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            return null;
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object elementAt(Type valueType, Block map, double key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            return null;
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object elementAt(Type valueType, Block map, Object key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            return null;
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }
}

