/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.time;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.type.DateTimes;
import java.time.LocalDateTime;

@ScalarFunction(value="$localtime", hidden=true)
public final class LocalTimeFunction {
    private LocalTimeFunction() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="time(p)")
    public static long localTime(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlNullable @SqlType(value="time(p)") Long dummy) {
        long nanos = LocalDateTime.ofInstant(session.getStart(), session.getTimeZoneKey().getZoneId()).toLocalTime().toNanoOfDay();
        long picos = nanos * 1000L;
        return DateTimes.round(picos, (int)(12L - precision)) % 86400000000000000L;
    }
}

