/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.operator.scalar.QuarterOfYearDateTimeField;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.DateTimes;
import org.joda.time.Chronology;
import org.joda.time.chrono.ISOChronology;

@Description(value="Quarter of the year of the given timestamp")
@ScalarFunction(value="quarter")
public class ExtractQuarter {
    private ExtractQuarter() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p)") long timestamp) {
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)ISOChronology.getInstanceUTC()).get(DateTimes.scaleEpochMicrosToMillis(timestamp));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return ExtractQuarter.extract(timestamp.getEpochMicros());
    }
}

