/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.DateTimes;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

@Description(value="Last day of the month of the given timestamp")
@ScalarFunction(value="last_day_of_month")
public class LastDayOfMonth {
    private static final int MILLISECONDS_IN_DAY = 86400000;

    private LastDayOfMonth() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long lastDayOfMonth(@SqlType(value="timestamp(p)") long timestamp) {
        long epochMillis = DateTimes.scaleEpochMicrosToMillis(timestamp);
        long millis = ISOChronology.getInstanceUTC().monthOfYear().roundCeiling(epochMillis + 1L) - 86400000L;
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long lastDayOfMonth(@SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return LastDayOfMonth.lastDayOfMonth(timestamp.getEpochMicros());
    }
}

