/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.operator.scalar.SequenceFunction;
import io.prestosql.operator.scalar.timestamp.DateDiff;
import io.prestosql.operator.scalar.timestamp.TimestampOperators;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.TimestampType;

@ScalarFunction(value="sequence")
public final class SequenceIntervalYearToMonth {
    private static final TimestampType SHORT_TYPE = TimestampType.createTimestampType((int)0);
    private static final TimestampType LONG_TYPE = TimestampType.createTimestampType((int)7);
    private static final Slice MONTH = Slices.utf8Slice((String)"month");

    private SequenceIntervalYearToMonth() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="array(timestamp(p))")
    public static Block sequence(@SqlType(value="timestamp(p)") long start, @SqlType(value="timestamp(p)") long stop, @SqlType(value="interval year to month") long step) {
        SequenceFunction.checkValidStep(start, stop, step);
        int length = Math.toIntExact(DateDiff.diff(MONTH, start, stop) / step + 1L);
        SequenceFunction.checkMaxEntry(length);
        BlockBuilder blockBuilder = SHORT_TYPE.createBlockBuilder(null, length);
        int offset = 0;
        for (int i = 0; i < length; ++i) {
            long value = TimestampOperators.TimestampPlusIntervalYearToMonth.add(start, (long)offset);
            SHORT_TYPE.writeLong(blockBuilder, value);
            offset = (int)((long)offset + step);
        }
        return blockBuilder.build();
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="array(timestamp(p))")
    public static Block sequence(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp start, @SqlType(value="timestamp(p)") LongTimestamp stop, @SqlType(value="interval year to month") long step) {
        SequenceFunction.checkValidStep(start.getEpochMicros(), stop.getEpochMicros(), step);
        int length = Math.toIntExact(DateDiff.diff(MONTH, start, stop) / step + 1L);
        SequenceFunction.checkMaxEntry(length);
        BlockBuilder blockBuilder = LONG_TYPE.createBlockBuilder(null, length);
        int offset = 0;
        for (int i = 0; i < length; ++i) {
            LongTimestamp value = TimestampOperators.TimestampPlusIntervalYearToMonth.add(start, (long)offset);
            LONG_TYPE.writeObject(blockBuilder, (Object)value);
            offset = (int)((long)offset + step);
        }
        return blockBuilder.build();
    }
}

