/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.operator.scalar.QuarterOfYearDateTimeField;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.Chronology;

@Description(value="Quarter of the year of the given timestamp")
@ScalarFunction(value="quarter")
public class ExtractQuarter {
    private ExtractQuarter() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)DateTimeZoneIndex.unpackChronology(packedEpochMillis)).get(DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()))).get(timestamp.getEpochMillis());
    }
}

