/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timetz;

import io.airlift.slice.Slice;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimeZoneNotSupportedException;
import io.prestosql.type.DateTimes;

@ScalarFunction(value="$at_timezone", hidden=true)
public class AtTimeZone {
    private AtTimeZone() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static long atTimeZone(ConnectorSession session, @SqlType(value="time(p) with time zone") long packedTime, @SqlType(value="varchar(x)") Slice zoneId) {
        TimeZoneKey zoneKey;
        try {
            zoneKey = TimeZoneKey.getTimeZoneKey((String)zoneId.toStringUtf8());
        }
        catch (TimeZoneNotSupportedException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("'%s' is not a valid time zone", zoneId));
        }
        int offsetMinutes = DateTimes.getOffsetMinutes(session.getStart(), zoneKey);
        long nanos = DateTimeEncoding.unpackTimeNanos((long)packedTime) - (long)(DateTimeEncoding.unpackOffsetMinutes((long)packedTime) - offsetMinutes) * 60000000000L;
        return DateTimeEncoding.packTimeWithTimeZone((long)Math.floorMod(nanos, 86400000000000L), (int)offsetMinutes);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static LongTimeWithTimeZone atTimeZone(ConnectorSession session, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone time, @SqlType(value="varchar(x)") Slice zoneId) {
        TimeZoneKey zoneKey;
        try {
            zoneKey = TimeZoneKey.getTimeZoneKey((String)zoneId.toStringUtf8());
        }
        catch (TimeZoneNotSupportedException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("'%s' is not a valid time zone", zoneId));
        }
        int offsetMinutes = DateTimes.getOffsetMinutes(session.getStart(), zoneKey);
        long picos = time.getPicoseconds() - (long)(time.getOffsetMinutes() - offsetMinutes) * 60000000000000L;
        return new LongTimeWithTimeZone(Math.floorMod(picos, 86400000000000000L), offsetMinutes);
    }
}

