/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timetz;

import io.airlift.slice.Slice;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import java.util.Locale;

@Description(value="Truncate to the specified precision")
@ScalarFunction(value="date_trunc")
public final class DateTrunc {
    private DateTrunc() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static long truncate(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="time(p) with time zone") long packedTime) {
        long picos = DateTimeEncoding.unpackTimeNanos((long)packedTime) * 1000L;
        return DateTimeEncoding.packTimeWithTimeZone((long)(DateTrunc.truncate(picos, unit) / 1000L), (int)DateTimeEncoding.unpackOffsetMinutes((long)packedTime));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static LongTimeWithTimeZone truncate(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone time) {
        return new LongTimeWithTimeZone(DateTrunc.truncate(time.getPicoseconds(), unit), time.getOffsetMinutes());
    }

    private static long truncate(long picos, Slice unit) {
        String unitString;
        switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "millisecond": {
                return picos / 1000000000L * 1000000000L;
            }
            case "second": {
                return picos / 1000000000000L * 1000000000000L;
            }
            case "minute": {
                return picos / 60000000000000L * 60000000000000L;
            }
            case "hour": {
                return picos / 3600000000000000L * 3600000000000000L;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid Time field");
    }
}

