/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timetz;

import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;

@Description(value="Minute of the hour of the given time")
@ScalarFunction(value="minute")
public class ExtractMinute {
    private ExtractMinute() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="time(p) with time zone") long packedTime) {
        return DateTimeEncoding.unpackTimeNanos((long)packedTime) / 60000000000L % 60L;
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone time) {
        return time.getPicoseconds() / 60000000000000L % 60L;
    }
}

