/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timetz;

import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import io.prestosql.type.DateTimes;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeWithTimeZoneToTimeCast {
    private TimeWithTimeZoneToTimeCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long cast(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="time(sourcePrecision) with time zone") long packedTime) {
        return TimeWithTimeZoneToTimeCast.convert(targetPrecision, DateTimeEncoding.unpackTimeNanos((long)packedTime) * 1000L);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long cast(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="time(sourcePrecision) with time zone") LongTimeWithTimeZone timestamp) {
        return TimeWithTimeZoneToTimeCast.convert(targetPrecision, timestamp.getPicoseconds());
    }

    private static long convert(long targetPrecision, long picos) {
        return DateTimes.round(picos, (int)(12L - targetPrecision)) % 86400000000000000L;
    }
}

