/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.util.Optional;

public class RangeJsonSerde {
    private RangeJsonSerde() {
    }

    public static class Deserializer
    extends JsonDeserializer<Range> {
        public Range deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            boolean isSingleValue = jsonParser.getByteValue() == 1;
            jsonParser.nextToken();
            if (isSingleValue) {
                Type type = (Type)deserializationContext.readValue(jsonParser, Type.class);
                jsonParser.nextToken();
                Block block = (Block)deserializationContext.readValue(jsonParser, Block.class);
                Marker marker = new Marker(type, Optional.of(block), Marker.Bound.EXACTLY);
                return new Range(marker, marker);
            }
            Marker low = (Marker)deserializationContext.readValue(jsonParser, Marker.class);
            jsonParser.nextToken();
            Marker high = (Marker)deserializationContext.readValue(jsonParser, Marker.class);
            return new Range(low, high);
        }
    }

    public static class Serializer
    extends JsonSerializer<Range> {
        public void serialize(Range range, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(range.isSingleValue() ? 1 : 0);
            if (range.isSingleValue()) {
                serializerProvider.findValueSerializer(Type.class).serialize((Object)range.getType(), jsonGenerator, serializerProvider);
                serializerProvider.findValueSerializer(Block.class).serialize(range.getLow().getValueBlock().get(), jsonGenerator, serializerProvider);
                return;
            }
            JsonSerializer markerSerializer = serializerProvider.findValueSerializer(Marker.class);
            markerSerializer.serialize((Object)range.getLow(), jsonGenerator, serializerProvider);
            markerSerializer.serialize((Object)range.getHigh(), jsonGenerator, serializerProvider);
        }
    }
}

