/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.jwt;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.jsonwebtoken.SigningKeyResolver;
import io.prestosql.server.security.jwt.FileSigningKeyResolver;
import io.prestosql.server.security.jwt.ForJwk;
import io.prestosql.server.security.jwt.JwkService;
import io.prestosql.server.security.jwt.JwkSigningKeyResolver;
import io.prestosql.server.security.jwt.JwtAuthenticatorConfig;

public class JwtAuthenticatorSupportModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(JwtAuthenticatorConfig.class);
        this.install(ConditionalModule.installModuleIf(JwtAuthenticatorConfig.class, JwtAuthenticatorSupportModule::isHttp, (Module)new JwkModule(), jwkBinder -> jwkBinder.bind(SigningKeyResolver.class).to(FileSigningKeyResolver.class).in(Scopes.SINGLETON)));
    }

    private static boolean isHttp(JwtAuthenticatorConfig config) {
        return config.getKeyFile().startsWith("https://") || config.getKeyFile().startsWith("http://");
    }

    private static class JwkModule
    implements Module {
        private JwkModule() {
        }

        public void configure(Binder binder) {
            binder.bind(SigningKeyResolver.class).to(JwkSigningKeyResolver.class).in(Scopes.SINGLETON);
            binder.bind(JwkService.class).in(Scopes.SINGLETON);
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("jwk", ForJwk.class);
        }

        public int hashCode() {
            return JwkModule.class.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof JwkModule;
        }
    }
}

