/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.oauth2;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.units.Duration;
import io.jsonwebtoken.SigningKeyResolver;
import io.prestosql.server.security.jwt.JwkService;
import io.prestosql.server.security.jwt.JwkSigningKeyResolver;
import io.prestosql.server.security.oauth2.ForOAuth2;
import io.prestosql.server.security.oauth2.OAuth2CallbackResource;
import io.prestosql.server.security.oauth2.OAuth2Client;
import io.prestosql.server.security.oauth2.OAuth2Config;
import io.prestosql.server.security.oauth2.OAuth2Service;
import io.prestosql.server.security.oauth2.ScribeJavaOAuth2Client;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public class OAuth2ServiceModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(OAuth2CallbackResource.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(OAuth2Config.class);
        binder.bind(OAuth2Service.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setDefault().to(ScribeJavaOAuth2Client.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("oauth2-jwk", ForOAuth2.class);
    }

    @Provides
    @Singleton
    @ForOAuth2
    public static SigningKeyResolver createSigningKeyResolver(OAuth2Config oauth2Config, @ForOAuth2 HttpClient httpClient) {
        return new JwkSigningKeyResolver(new JwkService(URI.create(oauth2Config.getJwksUrl()), httpClient, new Duration(15.0, TimeUnit.MINUTES)));
    }

    public int hashCode() {
        return OAuth2ServiceModule.class.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof OAuth2ServiceModule;
    }
}

