/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import io.prestosql.server.ServletSecurityUtils;
import io.prestosql.server.ui.FixedUserWebUiConfig;
import io.prestosql.server.ui.FormWebUiAuthenticationFilter;
import io.prestosql.server.ui.WebUiAuthenticationFilter;
import io.prestosql.spi.security.BasicPrincipal;
import io.prestosql.spi.security.Identity;
import java.security.Principal;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;

public class FixedUserWebUiAuthenticationFilter
implements WebUiAuthenticationFilter {
    private final Identity webUiIdentity;

    @Inject
    public FixedUserWebUiAuthenticationFilter(FixedUserWebUiConfig config) {
        this(FixedUserWebUiAuthenticationFilter.basicIdentity(Objects.requireNonNull(config, "config is null").getUsername()));
    }

    public FixedUserWebUiAuthenticationFilter(Identity webUiIdentity) {
        this.webUiIdentity = Objects.requireNonNull(webUiIdentity, "webUiIdentity is null");
    }

    public void filter(ContainerRequestContext request) {
        if (FormWebUiAuthenticationFilter.redirectAllFormLoginToUi(request)) {
            return;
        }
        ServletSecurityUtils.setAuthenticatedIdentity(request, this.webUiIdentity);
    }

    private static Identity basicIdentity(String username) {
        Objects.requireNonNull(username, "username is null");
        return Identity.forUser((String)username).withPrincipal((Principal)new BasicPrincipal(username)).build();
    }
}

