/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import io.prestosql.server.security.SecurityConfig;
import io.prestosql.server.ui.FormAuthenticator;
import java.util.Objects;
import javax.inject.Inject;

public class InsecureFormAuthenticator
implements FormAuthenticator {
    private final boolean insecureAuthenticationOverHttpAllowed;

    @Inject
    public InsecureFormAuthenticator(SecurityConfig securityConfig) {
        this.insecureAuthenticationOverHttpAllowed = Objects.requireNonNull(securityConfig, "securityConfig is null").isInsecureAuthenticationOverHttpAllowed();
    }

    @Override
    public boolean isLoginEnabled(boolean secure) {
        return secure || this.insecureAuthenticationOverHttpAllowed;
    }

    @Override
    public boolean isPasswordAllowed(boolean secure) {
        return false;
    }

    @Override
    public boolean isValidCredential(String username, String password, boolean secure) {
        if (username == null) {
            return false;
        }
        return this.isLoginEnabled(secure) && password == null;
    }
}

