/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionInvoker;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.type.FunctionType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class InterpretedFunctionInvoker {
    private final Metadata metadata;

    public InterpretedFunctionInvoker(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public Object invoke(ResolvedFunction function, ConnectorSession session, Object ... arguments) {
        return this.invoke(function, session, Arrays.asList(arguments));
    }

    public Object invoke(ResolvedFunction function, ConnectorSession session, List<Object> arguments) {
        FunctionMetadata functionMetadata = this.metadata.getFunctionMetadata(function);
        FunctionInvoker invoker = this.metadata.getScalarFunctionInvoker(function, InterpretedFunctionInvoker.getInvocationConvention(function, functionMetadata));
        return InterpretedFunctionInvoker.invoke(functionMetadata, invoker, session, arguments);
    }

    public static Object invoke(FunctionMetadata functionMetadata, FunctionInvoker invoker, ConnectorSession session, List<Object> arguments) {
        MethodHandle method = invoker.getMethodHandle();
        ArrayList<Object> actualArguments = new ArrayList<Object>();
        if (invoker.getInstanceFactory().isPresent()) {
            try {
                actualArguments.add(invoker.getInstanceFactory().get().invoke());
            }
            catch (Throwable throwable) {
                throw InterpretedFunctionInvoker.propagate(throwable);
            }
        }
        if (method.type().parameterCount() > actualArguments.size() && method.type().parameterType(actualArguments.size()) == ConnectorSession.class) {
            actualArguments.add(session);
        }
        int lambdaArgumentIndex = 0;
        for (int i = 0; i < arguments.size(); ++i) {
            Object argument = arguments.get(i);
            if (argument == null && !functionMetadata.getArgumentDefinitions().get(i).isNullable()) {
                return null;
            }
            if (functionMetadata.getSignature().getArgumentTypes().get(i).getBase().equals("function")) {
                argument = MethodHandleProxies.asInterfaceInstance(invoker.getLambdaInterfaces().get(lambdaArgumentIndex), (MethodHandle)argument);
                ++lambdaArgumentIndex;
            }
            actualArguments.add(argument);
        }
        try {
            return method.invokeWithArguments(actualArguments);
        }
        catch (Throwable throwable) {
            throw InterpretedFunctionInvoker.propagate(throwable);
        }
    }

    private static InvocationConvention getInvocationConvention(ResolvedFunction function, FunctionMetadata functionMetadata) {
        ImmutableList.Builder argumentConventions = ImmutableList.builder();
        for (int i = 0; i < functionMetadata.getArgumentDefinitions().size(); ++i) {
            if (function.getSignature().getArgumentTypes().get(i) instanceof FunctionType) {
                argumentConventions.add((Object)InvocationConvention.InvocationArgumentConvention.FUNCTION);
                continue;
            }
            if (functionMetadata.getArgumentDefinitions().get(i).isNullable()) {
                argumentConventions.add((Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE);
                continue;
            }
            argumentConventions.add((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
        }
        return new InvocationConvention((List)argumentConventions.build(), functionMetadata.isNullable() ? InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN : InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, true, true);
    }

    private static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }
}

