/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.SqlPathElement;
import io.prestosql.sql.parser.SqlParser;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SqlPath {
    private List<SqlPathElement> parsedPath;
    private final Optional<String> rawPath;

    @JsonCreator
    public SqlPath(@JsonProperty(value="rawPath") Optional<String> path) {
        Objects.requireNonNull(path, "path is null");
        this.rawPath = path;
    }

    @JsonProperty
    public Optional<String> getRawPath() {
        return this.rawPath;
    }

    public List<SqlPathElement> getParsedPath() {
        if (this.parsedPath == null) {
            this.parsePath();
        }
        return this.parsedPath;
    }

    private void parsePath() {
        Preconditions.checkState((boolean)this.rawPath.isPresent(), (Object)"rawPath must be present to parse");
        SqlParser parser = new SqlParser();
        List pathSpecification = parser.createPathSpecification(this.rawPath.get()).getPath();
        this.parsedPath = (List)pathSpecification.stream().map(pathElement -> new SqlPathElement(pathElement.getCatalog(), pathElement.getSchema())).collect(ImmutableList.toImmutableList());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlPath that = (SqlPath)obj;
        return Objects.equals(this.parsedPath, that.parsedPath);
    }

    public int hashCode() {
        return Objects.hash(this.parsedPath);
    }

    public String toString() {
        if (this.rawPath.isPresent()) {
            return Joiner.on((String)", ").join(this.getParsedPath());
        }
        return "";
    }
}

