/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SpecialForm;
import java.util.Objects;

public class AndCodeGenerator
implements BytecodeGenerator {
    private final RowExpression left;
    private final RowExpression right;

    public AndCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        Preconditions.checkArgument((specialForm.getArguments().size() == 2 ? 1 : 0) != 0);
        this.left = specialForm.getArguments().get(0);
        this.right = specialForm.getArguments().get(1);
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generator) {
        Variable wasNull = generator.wasNull();
        BytecodeBlock block = new BytecodeBlock().comment("AND").setDescription("AND");
        block.append(generator.generate(this.left));
        IfStatement ifLeftIsNull = new IfStatement("if left wasNull...", new Object[0]).condition((BytecodeNode)wasNull);
        LabelNode end = new LabelNode("end");
        ifLeftIsNull.ifTrue().comment("clear the null flag, pop left value off stack, and push left null flag on the stack (true)").append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).pop(this.left.getType().getJavaType()).push(true);
        LabelNode leftIsTrue = new LabelNode("leftIsTrue");
        ifLeftIsNull.ifFalse().comment("if left is false, push false, and goto end").ifTrueGoto(leftIsTrue).push(false).gotoLabel(end).comment("left was true; push left null flag on the stack (false)").visitLabel(leftIsTrue).push(false);
        block.append((BytecodeNode)ifLeftIsNull);
        block.append(generator.generate(this.right));
        IfStatement ifRightIsNull = new IfStatement("if right wasNull...", new Object[0]);
        ifRightIsNull.condition().append((BytecodeNode)wasNull);
        ifRightIsNull.ifTrue().comment("right was null, pop the right value off the stack; wasNull flag remains set to TRUE").pop(this.right.getType().getJavaType());
        LabelNode rightIsTrue = new LabelNode("rightIsTrue");
        ifRightIsNull.ifFalse().comment("if right is false, pop left null flag off stack, push false and goto end").ifTrueGoto(rightIsTrue).pop(Boolean.TYPE).push(false).gotoLabel(end).comment("right was true; store left null flag (on stack) in wasNull variable, and push true").visitLabel(rightIsTrue).putVariable(wasNull).push(true);
        block.append((BytecodeNode)ifRightIsNull).visitLabel(end);
        return block;
    }
}

