/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.SqlTypeBytecodeExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SpecialForm;
import java.util.Objects;

public class DereferenceCodeGenerator
implements BytecodeGenerator {
    private final Type returnType;
    private final RowExpression base;
    private final int index;

    public DereferenceCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        this.returnType = specialForm.getType();
        Preconditions.checkArgument((specialForm.getArguments().size() == 2 ? 1 : 0) != 0);
        this.base = specialForm.getArguments().get(0);
        this.index = (Integer)((ConstantExpression)specialForm.getArguments().get(1)).getValue();
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generator) {
        CallSiteBinder callSiteBinder = generator.getCallSiteBinder();
        BytecodeBlock block = new BytecodeBlock().comment("DEREFERENCE").setDescription("DEREFERENCE");
        Variable wasNull = generator.wasNull();
        Variable rowBlock = generator.getScope().createTempVariable(Block.class);
        block.putVariable(wasNull, false);
        block.append(generator.generate(this.base)).putVariable(rowBlock);
        IfStatement ifRowBlockIsNull = new IfStatement("if row block is null...", new Object[0]).condition((BytecodeNode)wasNull);
        Class javaType = this.returnType.getJavaType();
        LabelNode end = new LabelNode("end");
        ifRowBlockIsNull.ifTrue().comment("if row block is null, push null to the stack and goto 'end' label (return)").putVariable(wasNull, true).pushJavaDefault(javaType).gotoLabel(end);
        block.append((BytecodeNode)ifRowBlockIsNull);
        IfStatement ifFieldIsNull = new IfStatement("if row field is null...", new Object[0]);
        ifFieldIsNull.condition().comment("call rowBlock.isNull(index)").append((BytecodeNode)rowBlock).push(this.index).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE});
        ifFieldIsNull.ifTrue().comment("if the field is null, push null to stack").putVariable(wasNull, true).pushJavaDefault(javaType);
        BytecodeExpression value = SqlTypeBytecodeExpression.constantType(callSiteBinder, this.returnType).getValue((BytecodeExpression)rowBlock, BytecodeExpressions.constantInt((int)this.index));
        ifFieldIsNull.ifFalse().comment("otherwise call type.getTYPE(rowBlock, index)").append((BytecodeNode)value).putVariable(wasNull, false);
        block.append((BytecodeNode)ifFieldIsNull).visitLabel(end);
        return block;
    }
}

