/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.SqlTypeBytecodeExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SpecialForm;
import java.util.List;
import java.util.Objects;

public class RowConstructorCodeGenerator
implements BytecodeGenerator {
    private final Type rowType;
    private final List<RowExpression> arguments;

    public RowConstructorCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        this.rowType = specialForm.getType();
        this.arguments = specialForm.getArguments();
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext context) {
        BytecodeBlock block = new BytecodeBlock().setDescription("Constructor for " + this.rowType);
        CallSiteBinder binder = context.getCallSiteBinder();
        Scope scope = context.getScope();
        List types = this.rowType.getTypeParameters();
        block.comment("Create new RowBlockBuilder; beginBlockEntry;");
        Variable blockBuilder = scope.createTempVariable(BlockBuilder.class);
        Variable singleRowBlockWriter = scope.createTempVariable(BlockBuilder.class);
        block.append((BytecodeNode)blockBuilder.set(SqlTypeBytecodeExpression.constantType(binder, this.rowType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), BytecodeExpressions.constantInt((int)1)})));
        block.append((BytecodeNode)singleRowBlockWriter.set(blockBuilder.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
        for (int i = 0; i < this.arguments.size(); ++i) {
            Type fieldType = (Type)types.get(i);
            Variable field = scope.createTempVariable(fieldType.getJavaType());
            block.comment("Clean wasNull and Generate + " + i + "-th field of row");
            block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
            block.append(context.generate(this.arguments.get(i)));
            block.putVariable(field);
            block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)context.wasNull()).ifTrue((BytecodeNode)singleRowBlockWriter.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, fieldType).writeValue((BytecodeExpression)singleRowBlockWriter, (BytecodeExpression)field).pop()));
        }
        block.comment("closeEntry; slice the SingleRowBlock; wasNull = false;");
        block.append((BytecodeNode)blockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop());
        block.append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, this.rowType).invoke("getObject", Object.class, new BytecodeExpression[]{blockBuilder.cast(Block.class), BytecodeExpressions.constantInt((int)0)}).cast(Block.class));
        block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
        return block;
    }
}

