/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.scheduler.BucketNodeMap;
import io.prestosql.execution.scheduler.FixedBucketNodeMap;
import io.prestosql.execution.scheduler.NodeScheduler;
import io.prestosql.execution.scheduler.group.DynamicBucketNodeMap;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.Split;
import io.prestosql.operator.BucketPartitionFunction;
import io.prestosql.operator.PartitionFunction;
import io.prestosql.spi.connector.BucketFunction;
import io.prestosql.spi.connector.ConnectorBucketNodeMap;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.Type;
import io.prestosql.split.EmptySplit;
import io.prestosql.sql.planner.NodePartitionMap;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.type.BlockTypeOperators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;

public class NodePartitioningManager {
    private final NodeScheduler nodeScheduler;
    private final BlockTypeOperators blockTypeOperators;
    private final ConcurrentMap<CatalogName, ConnectorNodePartitioningProvider> partitioningProviders = new ConcurrentHashMap<CatalogName, ConnectorNodePartitioningProvider>();

    @Inject
    public NodePartitioningManager(NodeScheduler nodeScheduler, BlockTypeOperators blockTypeOperators) {
        this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    public void addPartitioningProvider(CatalogName catalogName, ConnectorNodePartitioningProvider nodePartitioningProvider) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        Preconditions.checkArgument((this.partitioningProviders.putIfAbsent(catalogName, nodePartitioningProvider) == null ? 1 : 0) != 0, (String)"NodePartitioningProvider for connector '%s' is already registered", (Object)catalogName);
    }

    public void removePartitioningProvider(CatalogName catalogName) {
        this.partitioningProviders.remove(catalogName);
    }

    public PartitionFunction getPartitionFunction(Session session, PartitioningScheme partitioningScheme, List<Type> partitionChannelTypes) {
        Optional<int[]> bucketToPartition = partitioningScheme.getBucketToPartition();
        Preconditions.checkArgument((boolean)bucketToPartition.isPresent(), (Object)"Bucket to partition must be set before a partition function can be created");
        PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
        if (partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) {
            Preconditions.checkArgument((boolean)partitioningScheme.getBucketToPartition().isPresent(), (Object)"Bucket to partition must be set before a partition function can be created");
            return ((SystemPartitioningHandle)partitioningHandle.getConnectorHandle()).getPartitionFunction(partitionChannelTypes, partitioningScheme.getHashColumn().isPresent(), partitioningScheme.getBucketToPartition().get(), this.blockTypeOperators);
        }
        CatalogName catalogName = partitioningHandle.getConnectorId().get();
        ConnectorNodePartitioningProvider partitioningProvider = (ConnectorNodePartitioningProvider)this.partitioningProviders.get(catalogName);
        Preconditions.checkArgument((partitioningProvider != null ? 1 : 0) != 0, (String)"No partitioning provider for connector %s", (Object)catalogName);
        BucketFunction bucketFunction = partitioningProvider.getBucketFunction((ConnectorTransactionHandle)partitioningHandle.getTransactionHandle().orElse(null), session.toConnectorSession(catalogName), partitioningHandle.getConnectorHandle(), partitionChannelTypes, bucketToPartition.get().length);
        Preconditions.checkArgument((bucketFunction != null ? 1 : 0) != 0, (String)"No function %s", (Object)partitioningHandle);
        return new BucketPartitionFunction(bucketFunction, partitioningScheme.getBucketToPartition().get());
    }

    public List<ConnectorPartitionHandle> listPartitionHandles(Session session, PartitioningHandle partitioningHandle) {
        ConnectorNodePartitioningProvider partitioningProvider = (ConnectorNodePartitioningProvider)this.partitioningProviders.get(partitioningHandle.getConnectorId().get());
        return partitioningProvider.listPartitionHandles((ConnectorTransactionHandle)partitioningHandle.getTransactionHandle().orElse(null), session.toConnectorSession(partitioningHandle.getConnectorId().get()), partitioningHandle.getConnectorHandle());
    }

    public NodePartitionMap getNodePartitioningMap(Session session, PartitioningHandle partitioningHandle) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
        if (partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) {
            return ((SystemPartitioningHandle)partitioningHandle.getConnectorHandle()).getNodePartitionMap(session, this.nodeScheduler);
        }
        CatalogName catalogName = partitioningHandle.getConnectorId().orElseThrow(() -> new IllegalArgumentException("No connector ID for partitioning handle: " + partitioningHandle));
        ConnectorNodePartitioningProvider partitioningProvider = (ConnectorNodePartitioningProvider)this.partitioningProviders.get(catalogName);
        Preconditions.checkArgument((partitioningProvider != null ? 1 : 0) != 0, (String)"No partitioning provider for connector %s", (Object)catalogName);
        ConnectorBucketNodeMap connectorBucketNodeMap = this.getConnectorBucketNodeMap(session, partitioningHandle);
        Preconditions.checkArgument((connectorBucketNodeMap.getBucketCount() < 1000000 ? 1 : 0) != 0, (String)"Too many buckets in partitioning: %s", (int)connectorBucketNodeMap.getBucketCount());
        List<InternalNode> bucketToNode = connectorBucketNodeMap.hasFixedMapping() ? NodePartitioningManager.getFixedMapping(connectorBucketNodeMap) : NodePartitioningManager.createArbitraryBucketToNode(this.nodeScheduler.createNodeSelector(Optional.of(catalogName)).allNodes(), connectorBucketNodeMap.getBucketCount());
        int[] bucketToPartition = new int[connectorBucketNodeMap.getBucketCount()];
        HashBiMap nodeToPartition = HashBiMap.create();
        int nextPartitionId = 0;
        for (int bucket = 0; bucket < bucketToNode.size(); ++bucket) {
            InternalNode node = bucketToNode.get(bucket);
            Integer partitionId = (Integer)nodeToPartition.get((Object)node);
            if (partitionId == null) {
                partitionId = nextPartitionId++;
                nodeToPartition.put((Object)node, (Object)partitionId);
            }
            bucketToPartition[bucket] = partitionId;
        }
        List partitionToNode = (List)IntStream.range(0, nodeToPartition.size()).mapToObj(arg_0 -> NodePartitioningManager.lambda$getNodePartitioningMap$1((BiMap)nodeToPartition, arg_0)).collect(ImmutableList.toImmutableList());
        return new NodePartitionMap(partitionToNode, bucketToPartition, this.getSplitToBucket(session, partitioningHandle));
    }

    public BucketNodeMap getBucketNodeMap(Session session, PartitioningHandle partitioningHandle, boolean preferDynamic) {
        ConnectorBucketNodeMap connectorBucketNodeMap = this.getConnectorBucketNodeMap(session, partitioningHandle);
        if (connectorBucketNodeMap.hasFixedMapping()) {
            return new FixedBucketNodeMap(this.getSplitToBucket(session, partitioningHandle), NodePartitioningManager.getFixedMapping(connectorBucketNodeMap));
        }
        if (preferDynamic) {
            return new DynamicBucketNodeMap(this.getSplitToBucket(session, partitioningHandle), connectorBucketNodeMap.getBucketCount());
        }
        Optional<CatalogName> catalogName = partitioningHandle.getConnectorId();
        catalogName.orElseThrow(() -> new IllegalArgumentException("No connector ID for partitioning handle: " + partitioningHandle));
        return new FixedBucketNodeMap(this.getSplitToBucket(session, partitioningHandle), NodePartitioningManager.createArbitraryBucketToNode(new ArrayList<InternalNode>(this.nodeScheduler.createNodeSelector(catalogName).allNodes()), connectorBucketNodeMap.getBucketCount()));
    }

    private static List<InternalNode> getFixedMapping(ConnectorBucketNodeMap connectorBucketNodeMap) {
        return (List)connectorBucketNodeMap.getFixedMapping().stream().map(InternalNode.class::cast).collect(ImmutableList.toImmutableList());
    }

    private ConnectorBucketNodeMap getConnectorBucketNodeMap(Session session, PartitioningHandle partitioningHandle) {
        Preconditions.checkArgument((!(partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) ? 1 : 0) != 0);
        ConnectorNodePartitioningProvider partitioningProvider = (ConnectorNodePartitioningProvider)this.partitioningProviders.get(partitioningHandle.getConnectorId().get());
        Preconditions.checkArgument((partitioningProvider != null ? 1 : 0) != 0, (String)"No partitioning provider for connector %s", (Object)partitioningHandle.getConnectorId().get());
        ConnectorBucketNodeMap connectorBucketNodeMap = partitioningProvider.getBucketNodeMap((ConnectorTransactionHandle)partitioningHandle.getTransactionHandle().orElse(null), session.toConnectorSession(partitioningHandle.getConnectorId().get()), partitioningHandle.getConnectorHandle());
        Preconditions.checkArgument((connectorBucketNodeMap != null ? 1 : 0) != 0, (String)"No partition map %s", (Object)partitioningHandle);
        return connectorBucketNodeMap;
    }

    private ToIntFunction<Split> getSplitToBucket(Session session, PartitioningHandle partitioningHandle) {
        ConnectorNodePartitioningProvider partitioningProvider = (ConnectorNodePartitioningProvider)this.partitioningProviders.get(partitioningHandle.getConnectorId().get());
        Preconditions.checkArgument((partitioningProvider != null ? 1 : 0) != 0, (String)"No partitioning provider for connector %s", (Object)partitioningHandle.getConnectorId().get());
        ToIntFunction splitBucketFunction = partitioningProvider.getSplitBucketFunction((ConnectorTransactionHandle)partitioningHandle.getTransactionHandle().orElse(null), session.toConnectorSession(partitioningHandle.getConnectorId().get()), partitioningHandle.getConnectorHandle());
        Preconditions.checkArgument((splitBucketFunction != null ? 1 : 0) != 0, (String)"No partitioning %s", (Object)partitioningHandle);
        return split -> {
            int bucket = split.getConnectorSplit() instanceof EmptySplit ? (split.getLifespan().isTaskWide() ? 0 : split.getLifespan().getId()) : splitBucketFunction.applyAsInt(split.getConnectorSplit());
            if (!split.getLifespan().isTaskWide()) {
                Preconditions.checkArgument((split.getLifespan().getId() == bucket ? 1 : 0) != 0);
            }
            return bucket;
        };
    }

    private static List<InternalNode> createArbitraryBucketToNode(List<InternalNode> nodes, int bucketCount) {
        return (List)NodePartitioningManager.cyclingShuffledStream(nodes).limit(bucketCount).collect(ImmutableList.toImmutableList());
    }

    private static <T> Stream<T> cyclingShuffledStream(Collection<T> collection) {
        ArrayList list = new ArrayList(collection);
        Collections.shuffle(list);
        return Stream.generate(() -> list).flatMap(Collection::stream);
    }

    private static /* synthetic */ InternalNode lambda$getNodePartitioningMap$1(BiMap nodeToPartition, int partitionId) {
        return (InternalNode)nodeToPartition.inverse().get((Object)partitionId);
    }
}

