/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.ExpressionNodeInliner;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.DereferencePushdown;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExtractDereferencesFromFilterAboveScan
implements Rule<FilterNode> {
    private static final Capture<TableScanNode> CHILD = Capture.newCapture();
    private final TypeAnalyzer typeAnalyzer;

    public ExtractDereferencesFromFilterAboveScan(TypeAnalyzer typeAnalyzer) {
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(CHILD)));
    }

    @Override
    public Rule.Result apply(FilterNode node, Captures captures, Rule.Context context) {
        Set<DereferenceExpression> dereferences = DereferencePushdown.extractDereferences((Collection<Expression>)ImmutableList.of((Object)node.getPredicate()), true);
        if (dereferences.isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments assignments = Assignments.of(dereferences, context.getSession(), context.getSymbolAllocator(), this.typeAnalyzer);
        Map mappings = (Map)HashBiMap.create(assignments.getMap()).inverse().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
        PlanNode source = node.getSource();
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new FilterNode(context.getIdAllocator().getNextId(), new ProjectNode(context.getIdAllocator().getNextId(), source, Assignments.builder().putIdentities(source.getOutputSymbols()).putAll(assignments).build()), ExpressionNodeInliner.replaceExpression(node.getPredicate(), mappings)), Assignments.identity(node.getOutputSymbols())));
    }
}

