/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ImplementFilteredAggregations
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(ImplementFilteredAggregations::hasFilters);
    private final Metadata metadata;

    public ImplementFilteredAggregations(Metadata metadata) {
        this.metadata = metadata;
    }

    private static boolean hasFilters(AggregationNode aggregation) {
        return aggregation.getAggregations().values().stream().anyMatch(e -> e.getFilter().isPresent());
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        Assignments.Builder newAssignments = Assignments.builder();
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        ImmutableList.Builder maskSymbols = ImmutableList.builder();
        boolean aggregateWithoutFilterOrMaskPresent = false;
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregationNode.getAggregations().entrySet()) {
            Symbol output = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            Optional<Symbol> mask = aggregation.getMask();
            if (aggregation.getFilter().isPresent()) {
                Symbol filter = aggregation.getFilter().get();
                if (mask.isPresent()) {
                    Symbol newMask = context.getSymbolAllocator().newSymbol("mask", (Type)BooleanType.BOOLEAN);
                    Expression expression = ExpressionUtils.and(new Expression[]{mask.get().toSymbolReference(), filter.toSymbolReference()});
                    newAssignments.put(newMask, expression);
                    mask = Optional.of(newMask);
                    maskSymbols.add((Object)newMask.toSymbolReference());
                } else {
                    mask = Optional.of(filter);
                    maskSymbols.add((Object)filter.toSymbolReference());
                }
            } else if (mask.isPresent()) {
                maskSymbols.add((Object)mask.get().toSymbolReference());
            } else {
                aggregateWithoutFilterOrMaskPresent = true;
            }
            aggregations.put((Object)output, (Object)new AggregationNode.Aggregation(aggregation.getResolvedFunction(), aggregation.getArguments(), aggregation.isDistinct(), Optional.empty(), aggregation.getOrderingScheme(), mask));
        }
        BooleanLiteral predicate = BooleanLiteral.TRUE_LITERAL;
        if (!aggregationNode.hasNonEmptyGroupingSet() && !aggregateWithoutFilterOrMaskPresent) {
            predicate = ExpressionUtils.combineDisjunctsWithDefault(this.metadata, (Collection<Expression>)maskSymbols.build(), (Expression)BooleanLiteral.TRUE_LITERAL);
        }
        newAssignments.putIdentities(aggregationNode.getSource().getOutputSymbols());
        return Rule.Result.ofPlanNode(new AggregationNode(context.getIdAllocator().getNextId(), new FilterNode(context.getIdAllocator().getNextId(), new ProjectNode(context.getIdAllocator().getNextId(), aggregationNode.getSource(), newAssignments.build()), (Expression)predicate), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), aggregationNode.getGroupingSets(), (List<Symbol>)ImmutableList.of(), aggregationNode.getStep(), aggregationNode.getHashSymbol(), aggregationNode.getGroupIdSymbol()));
    }
}

