/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.StatisticAggregations;
import io.prestosql.sql.planner.plan.TableWriterNode;
import java.util.Set;

public class PruneTableWriterSourceColumns
implements Rule<TableWriterNode> {
    private static final Pattern<TableWriterNode> PATTERN = Patterns.tableWriterNode();

    @Override
    public Pattern<TableWriterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableWriterNode tableWriterNode, Captures captures, Rule.Context context) {
        ImmutableSet.Builder requiredInputs = ImmutableSet.builder().addAll(tableWriterNode.getColumns());
        if (tableWriterNode.getPartitioningScheme().isPresent()) {
            PartitioningScheme partitioningScheme = tableWriterNode.getPartitioningScheme().get();
            partitioningScheme.getPartitioning().getColumns().forEach(arg_0 -> ((ImmutableSet.Builder)requiredInputs).add(arg_0));
            partitioningScheme.getHashColumn().ifPresent(arg_0 -> ((ImmutableSet.Builder)requiredInputs).add(arg_0));
        }
        if (tableWriterNode.getStatisticsAggregation().isPresent()) {
            StatisticAggregations aggregations = tableWriterNode.getStatisticsAggregation().get();
            requiredInputs.addAll(aggregations.getGroupingSymbols());
            aggregations.getAggregations().values().stream().map(SymbolsExtractor::extractUnique).forEach(arg_0 -> ((ImmutableSet.Builder)requiredInputs).addAll(arg_0));
        }
        return Util.restrictChildOutputs(context.getIdAllocator(), tableWriterNode, new Set[]{requiredInputs.build()}).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

